/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CreditSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.ElasticGpuSpecification;
import software.amazon.awssdk.services.ec2.model.ElasticGpuSpecificationListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateBlockDeviceMappingRequest;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateBlockDeviceMappingRequestListCopier;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateCapacityReservationSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateCpuOptionsRequest;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateElasticInferenceAccelerator;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateElasticInferenceAcceleratorListCopier;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateEnclaveOptionsRequest;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateHibernationOptionsRequest;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateIamInstanceProfileSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMarketOptionsRequest;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataOptionsRequest;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecificationRequestListCopier;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateLicenseConfigurationRequest;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateLicenseSpecificationListRequestCopier;
import software.amazon.awssdk.services.ec2.model.LaunchTemplatePlacementRequest;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateTagSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateTagSpecificationRequestListCopier;
import software.amazon.awssdk.services.ec2.model.LaunchTemplatesMonitoringRequest;
import software.amazon.awssdk.services.ec2.model.SecurityGroupIdStringListCopier;
import software.amazon.awssdk.services.ec2.model.SecurityGroupStringListCopier;
import software.amazon.awssdk.services.ec2.model.ShutdownBehavior;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RequestLaunchTemplateData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RequestLaunchTemplateData> {
    private static final SdkField<String> KERNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KernelId").getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::kernelId)).setter(RequestLaunchTemplateData.setter(Builder::kernelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelId").unmarshallLocationName("KernelId").build()}).build();
    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EbsOptimized").getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::ebsOptimized)).setter(RequestLaunchTemplateData.setter(Builder::ebsOptimized)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized").unmarshallLocationName("EbsOptimized").build()}).build();
    private static final SdkField<LaunchTemplateIamInstanceProfileSpecificationRequest> IAM_INSTANCE_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IamInstanceProfile").getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::iamInstanceProfile)).setter(RequestLaunchTemplateData.setter(Builder::iamInstanceProfile)).constructor(LaunchTemplateIamInstanceProfileSpecificationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamInstanceProfile").unmarshallLocationName("IamInstanceProfile").build()}).build();
    private static final SdkField<List<LaunchTemplateBlockDeviceMappingRequest>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BlockDeviceMappings").getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::blockDeviceMappings)).setter(RequestLaunchTemplateData.setter(Builder::blockDeviceMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMapping").unmarshallLocationName("BlockDeviceMapping").build(), ListTrait.builder().memberLocationName("BlockDeviceMapping").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LaunchTemplateBlockDeviceMappingRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMapping").unmarshallLocationName("BlockDeviceMapping").build()}).build()).build()}).build();
    private static final SdkField<List<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest>> NETWORK_INTERFACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkInterfaces").getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::networkInterfaces)).setter(RequestLaunchTemplateData.setter(Builder::networkInterfaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterface").unmarshallLocationName("NetworkInterface").build(), ListTrait.builder().memberLocationName("InstanceNetworkInterfaceSpecification").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceNetworkInterfaceSpecification").unmarshallLocationName("InstanceNetworkInterfaceSpecification").build()}).build()).build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::imageId)).setter(RequestLaunchTemplateData.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").unmarshallLocationName("ImageId").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::instanceTypeAsString)).setter(RequestLaunchTemplateData.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("InstanceType").build()}).build();
    private static final SdkField<String> KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyName").getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::keyName)).setter(RequestLaunchTemplateData.setter(Builder::keyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").unmarshallLocationName("KeyName").build()}).build();
    private static final SdkField<LaunchTemplatesMonitoringRequest> MONITORING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Monitoring").getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::monitoring)).setter(RequestLaunchTemplateData.setter(Builder::monitoring)).constructor(LaunchTemplatesMonitoringRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monitoring").unmarshallLocationName("Monitoring").build()}).build();
    private static final SdkField<LaunchTemplatePlacementRequest> PLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Placement").getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::placement)).setter(RequestLaunchTemplateData.setter(Builder::placement)).constructor(LaunchTemplatePlacementRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Placement").unmarshallLocationName("Placement").build()}).build();
    private static final SdkField<String> RAM_DISK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RamDiskId").getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::ramDiskId)).setter(RequestLaunchTemplateData.setter(Builder::ramDiskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RamDiskId").unmarshallLocationName("RamDiskId").build()}).build();
    private static final SdkField<Boolean> DISABLE_API_TERMINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DisableApiTermination").getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::disableApiTermination)).setter(RequestLaunchTemplateData.setter(Builder::disableApiTermination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableApiTermination").unmarshallLocationName("DisableApiTermination").build()}).build();
    private static final SdkField<String> INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceInitiatedShutdownBehavior").getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::instanceInitiatedShutdownBehaviorAsString)).setter(RequestLaunchTemplateData.setter(Builder::instanceInitiatedShutdownBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceInitiatedShutdownBehavior").unmarshallLocationName("InstanceInitiatedShutdownBehavior").build()}).build();
    private static final SdkField<String> USER_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserData").getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::userData)).setter(RequestLaunchTemplateData.setter(Builder::userData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserData").unmarshallLocationName("UserData").build()}).build();
    private static final SdkField<List<LaunchTemplateTagSpecificationRequest>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::tagSpecifications)).setter(RequestLaunchTemplateData.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("LaunchTemplateTagSpecificationRequest").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LaunchTemplateTagSpecificationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateTagSpecificationRequest").unmarshallLocationName("LaunchTemplateTagSpecificationRequest").build()}).build()).build()}).build();
    private static final SdkField<List<ElasticGpuSpecification>> ELASTIC_GPU_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ElasticGpuSpecifications").getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::elasticGpuSpecifications)).setter(RequestLaunchTemplateData.setter(Builder::elasticGpuSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticGpuSpecification").unmarshallLocationName("ElasticGpuSpecification").build(), ListTrait.builder().memberLocationName("ElasticGpuSpecification").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ElasticGpuSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticGpuSpecification").unmarshallLocationName("ElasticGpuSpecification").build()}).build()).build()}).build();
    private static final SdkField<List<LaunchTemplateElasticInferenceAccelerator>> ELASTIC_INFERENCE_ACCELERATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ElasticInferenceAccelerators").getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::elasticInferenceAccelerators)).setter(RequestLaunchTemplateData.setter(Builder::elasticInferenceAccelerators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticInferenceAccelerator").unmarshallLocationName("ElasticInferenceAccelerator").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LaunchTemplateElasticInferenceAccelerator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::securityGroupIds)).setter(RequestLaunchTemplateData.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").unmarshallLocationName("SecurityGroupId").build(), ListTrait.builder().memberLocationName("SecurityGroupId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").unmarshallLocationName("SecurityGroupId").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::securityGroups)).setter(RequestLaunchTemplateData.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroup").unmarshallLocationName("SecurityGroup").build(), ListTrait.builder().memberLocationName("SecurityGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroup").unmarshallLocationName("SecurityGroup").build()}).build()).build()}).build();
    private static final SdkField<LaunchTemplateInstanceMarketOptionsRequest> INSTANCE_MARKET_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceMarketOptions").getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::instanceMarketOptions)).setter(RequestLaunchTemplateData.setter(Builder::instanceMarketOptions)).constructor(LaunchTemplateInstanceMarketOptionsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMarketOptions").unmarshallLocationName("InstanceMarketOptions").build()}).build();
    private static final SdkField<CreditSpecificationRequest> CREDIT_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreditSpecification").getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::creditSpecification)).setter(RequestLaunchTemplateData.setter(Builder::creditSpecification)).constructor(CreditSpecificationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreditSpecification").unmarshallLocationName("CreditSpecification").build()}).build();
    private static final SdkField<LaunchTemplateCpuOptionsRequest> CPU_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CpuOptions").getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::cpuOptions)).setter(RequestLaunchTemplateData.setter(Builder::cpuOptions)).constructor(LaunchTemplateCpuOptionsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CpuOptions").unmarshallLocationName("CpuOptions").build()}).build();
    private static final SdkField<LaunchTemplateCapacityReservationSpecificationRequest> CAPACITY_RESERVATION_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CapacityReservationSpecification").getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::capacityReservationSpecification)).setter(RequestLaunchTemplateData.setter(Builder::capacityReservationSpecification)).constructor(LaunchTemplateCapacityReservationSpecificationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationSpecification").unmarshallLocationName("CapacityReservationSpecification").build()}).build();
    private static final SdkField<List<LaunchTemplateLicenseConfigurationRequest>> LICENSE_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LicenseSpecifications").getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::licenseSpecifications)).setter(RequestLaunchTemplateData.setter(Builder::licenseSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseSpecification").unmarshallLocationName("LicenseSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LaunchTemplateLicenseConfigurationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<LaunchTemplateHibernationOptionsRequest> HIBERNATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HibernationOptions").getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::hibernationOptions)).setter(RequestLaunchTemplateData.setter(Builder::hibernationOptions)).constructor(LaunchTemplateHibernationOptionsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HibernationOptions").unmarshallLocationName("HibernationOptions").build()}).build();
    private static final SdkField<LaunchTemplateInstanceMetadataOptionsRequest> METADATA_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetadataOptions").getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::metadataOptions)).setter(RequestLaunchTemplateData.setter(Builder::metadataOptions)).constructor(LaunchTemplateInstanceMetadataOptionsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataOptions").unmarshallLocationName("MetadataOptions").build()}).build();
    private static final SdkField<LaunchTemplateEnclaveOptionsRequest> ENCLAVE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EnclaveOptions").getter(RequestLaunchTemplateData.getter(RequestLaunchTemplateData::enclaveOptions)).setter(RequestLaunchTemplateData.setter(Builder::enclaveOptions)).constructor(LaunchTemplateEnclaveOptionsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnclaveOptions").unmarshallLocationName("EnclaveOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KERNEL_ID_FIELD, EBS_OPTIMIZED_FIELD, IAM_INSTANCE_PROFILE_FIELD, BLOCK_DEVICE_MAPPINGS_FIELD, NETWORK_INTERFACES_FIELD, IMAGE_ID_FIELD, INSTANCE_TYPE_FIELD, KEY_NAME_FIELD, MONITORING_FIELD, PLACEMENT_FIELD, RAM_DISK_ID_FIELD, DISABLE_API_TERMINATION_FIELD, INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_FIELD, USER_DATA_FIELD, TAG_SPECIFICATIONS_FIELD, ELASTIC_GPU_SPECIFICATIONS_FIELD, ELASTIC_INFERENCE_ACCELERATORS_FIELD, SECURITY_GROUP_IDS_FIELD, SECURITY_GROUPS_FIELD, INSTANCE_MARKET_OPTIONS_FIELD, CREDIT_SPECIFICATION_FIELD, CPU_OPTIONS_FIELD, CAPACITY_RESERVATION_SPECIFICATION_FIELD, LICENSE_SPECIFICATIONS_FIELD, HIBERNATION_OPTIONS_FIELD, METADATA_OPTIONS_FIELD, ENCLAVE_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String kernelId;
    private final Boolean ebsOptimized;
    private final LaunchTemplateIamInstanceProfileSpecificationRequest iamInstanceProfile;
    private final List<LaunchTemplateBlockDeviceMappingRequest> blockDeviceMappings;
    private final List<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest> networkInterfaces;
    private final String imageId;
    private final String instanceType;
    private final String keyName;
    private final LaunchTemplatesMonitoringRequest monitoring;
    private final LaunchTemplatePlacementRequest placement;
    private final String ramDiskId;
    private final Boolean disableApiTermination;
    private final String instanceInitiatedShutdownBehavior;
    private final String userData;
    private final List<LaunchTemplateTagSpecificationRequest> tagSpecifications;
    private final List<ElasticGpuSpecification> elasticGpuSpecifications;
    private final List<LaunchTemplateElasticInferenceAccelerator> elasticInferenceAccelerators;
    private final List<String> securityGroupIds;
    private final List<String> securityGroups;
    private final LaunchTemplateInstanceMarketOptionsRequest instanceMarketOptions;
    private final CreditSpecificationRequest creditSpecification;
    private final LaunchTemplateCpuOptionsRequest cpuOptions;
    private final LaunchTemplateCapacityReservationSpecificationRequest capacityReservationSpecification;
    private final List<LaunchTemplateLicenseConfigurationRequest> licenseSpecifications;
    private final LaunchTemplateHibernationOptionsRequest hibernationOptions;
    private final LaunchTemplateInstanceMetadataOptionsRequest metadataOptions;
    private final LaunchTemplateEnclaveOptionsRequest enclaveOptions;

    private RequestLaunchTemplateData(BuilderImpl builder) {
        this.kernelId = builder.kernelId;
        this.ebsOptimized = builder.ebsOptimized;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.networkInterfaces = builder.networkInterfaces;
        this.imageId = builder.imageId;
        this.instanceType = builder.instanceType;
        this.keyName = builder.keyName;
        this.monitoring = builder.monitoring;
        this.placement = builder.placement;
        this.ramDiskId = builder.ramDiskId;
        this.disableApiTermination = builder.disableApiTermination;
        this.instanceInitiatedShutdownBehavior = builder.instanceInitiatedShutdownBehavior;
        this.userData = builder.userData;
        this.tagSpecifications = builder.tagSpecifications;
        this.elasticGpuSpecifications = builder.elasticGpuSpecifications;
        this.elasticInferenceAccelerators = builder.elasticInferenceAccelerators;
        this.securityGroupIds = builder.securityGroupIds;
        this.securityGroups = builder.securityGroups;
        this.instanceMarketOptions = builder.instanceMarketOptions;
        this.creditSpecification = builder.creditSpecification;
        this.cpuOptions = builder.cpuOptions;
        this.capacityReservationSpecification = builder.capacityReservationSpecification;
        this.licenseSpecifications = builder.licenseSpecifications;
        this.hibernationOptions = builder.hibernationOptions;
        this.metadataOptions = builder.metadataOptions;
        this.enclaveOptions = builder.enclaveOptions;
    }

    public final String kernelId() {
        return this.kernelId;
    }

    public final Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public final LaunchTemplateIamInstanceProfileSpecificationRequest iamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public final boolean hasBlockDeviceMappings() {
        return this.blockDeviceMappings != null && !(this.blockDeviceMappings instanceof SdkAutoConstructList);
    }

    public final List<LaunchTemplateBlockDeviceMappingRequest> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public final boolean hasNetworkInterfaces() {
        return this.networkInterfaces != null && !(this.networkInterfaces instanceof SdkAutoConstructList);
    }

    public final List<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest> networkInterfaces() {
        return this.networkInterfaces;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final String keyName() {
        return this.keyName;
    }

    public final LaunchTemplatesMonitoringRequest monitoring() {
        return this.monitoring;
    }

    public final LaunchTemplatePlacementRequest placement() {
        return this.placement;
    }

    public final String ramDiskId() {
        return this.ramDiskId;
    }

    public final Boolean disableApiTermination() {
        return this.disableApiTermination;
    }

    public final ShutdownBehavior instanceInitiatedShutdownBehavior() {
        return ShutdownBehavior.fromValue(this.instanceInitiatedShutdownBehavior);
    }

    public final String instanceInitiatedShutdownBehaviorAsString() {
        return this.instanceInitiatedShutdownBehavior;
    }

    public final String userData() {
        return this.userData;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<LaunchTemplateTagSpecificationRequest> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final boolean hasElasticGpuSpecifications() {
        return this.elasticGpuSpecifications != null && !(this.elasticGpuSpecifications instanceof SdkAutoConstructList);
    }

    public final List<ElasticGpuSpecification> elasticGpuSpecifications() {
        return this.elasticGpuSpecifications;
    }

    public final boolean hasElasticInferenceAccelerators() {
        return this.elasticInferenceAccelerators != null && !(this.elasticInferenceAccelerators instanceof SdkAutoConstructList);
    }

    public final List<LaunchTemplateElasticInferenceAccelerator> elasticInferenceAccelerators() {
        return this.elasticInferenceAccelerators;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroups() {
        return this.securityGroups;
    }

    public final LaunchTemplateInstanceMarketOptionsRequest instanceMarketOptions() {
        return this.instanceMarketOptions;
    }

    public final CreditSpecificationRequest creditSpecification() {
        return this.creditSpecification;
    }

    public final LaunchTemplateCpuOptionsRequest cpuOptions() {
        return this.cpuOptions;
    }

    public final LaunchTemplateCapacityReservationSpecificationRequest capacityReservationSpecification() {
        return this.capacityReservationSpecification;
    }

    public final boolean hasLicenseSpecifications() {
        return this.licenseSpecifications != null && !(this.licenseSpecifications instanceof SdkAutoConstructList);
    }

    public final List<LaunchTemplateLicenseConfigurationRequest> licenseSpecifications() {
        return this.licenseSpecifications;
    }

    public final LaunchTemplateHibernationOptionsRequest hibernationOptions() {
        return this.hibernationOptions;
    }

    public final LaunchTemplateInstanceMetadataOptionsRequest metadataOptions() {
        return this.metadataOptions;
    }

    public final LaunchTemplateEnclaveOptionsRequest enclaveOptions() {
        return this.enclaveOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlockDeviceMappings() ? this.blockDeviceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkInterfaces() ? this.networkInterfaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoring());
        hashCode = 31 * hashCode + Objects.hashCode(this.placement());
        hashCode = 31 * hashCode + Objects.hashCode(this.ramDiskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableApiTermination());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceInitiatedShutdownBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userData());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasElasticGpuSpecifications() ? this.elasticGpuSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasElasticInferenceAccelerators() ? this.elasticInferenceAccelerators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceMarketOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.creditSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpuOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservationSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLicenseSpecifications() ? this.licenseSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hibernationOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.enclaveOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestLaunchTemplateData)) {
            return false;
        }
        RequestLaunchTemplateData other = (RequestLaunchTemplateData)obj;
        return Objects.equals(this.kernelId(), other.kernelId()) && Objects.equals(this.ebsOptimized(), other.ebsOptimized()) && Objects.equals(this.iamInstanceProfile(), other.iamInstanceProfile()) && this.hasBlockDeviceMappings() == other.hasBlockDeviceMappings() && Objects.equals(this.blockDeviceMappings(), other.blockDeviceMappings()) && this.hasNetworkInterfaces() == other.hasNetworkInterfaces() && Objects.equals(this.networkInterfaces(), other.networkInterfaces()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.keyName(), other.keyName()) && Objects.equals(this.monitoring(), other.monitoring()) && Objects.equals(this.placement(), other.placement()) && Objects.equals(this.ramDiskId(), other.ramDiskId()) && Objects.equals(this.disableApiTermination(), other.disableApiTermination()) && Objects.equals(this.instanceInitiatedShutdownBehaviorAsString(), other.instanceInitiatedShutdownBehaviorAsString()) && Objects.equals(this.userData(), other.userData()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && this.hasElasticGpuSpecifications() == other.hasElasticGpuSpecifications() && Objects.equals(this.elasticGpuSpecifications(), other.elasticGpuSpecifications()) && this.hasElasticInferenceAccelerators() == other.hasElasticInferenceAccelerators() && Objects.equals(this.elasticInferenceAccelerators(), other.elasticInferenceAccelerators()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.instanceMarketOptions(), other.instanceMarketOptions()) && Objects.equals(this.creditSpecification(), other.creditSpecification()) && Objects.equals(this.cpuOptions(), other.cpuOptions()) && Objects.equals(this.capacityReservationSpecification(), other.capacityReservationSpecification()) && this.hasLicenseSpecifications() == other.hasLicenseSpecifications() && Objects.equals(this.licenseSpecifications(), other.licenseSpecifications()) && Objects.equals(this.hibernationOptions(), other.hibernationOptions()) && Objects.equals(this.metadataOptions(), other.metadataOptions()) && Objects.equals(this.enclaveOptions(), other.enclaveOptions());
    }

    public final String toString() {
        return ToString.builder((String)"RequestLaunchTemplateData").add("KernelId", (Object)this.kernelId()).add("EbsOptimized", (Object)this.ebsOptimized()).add("IamInstanceProfile", (Object)this.iamInstanceProfile()).add("BlockDeviceMappings", this.hasBlockDeviceMappings() ? this.blockDeviceMappings() : null).add("NetworkInterfaces", this.hasNetworkInterfaces() ? this.networkInterfaces() : null).add("ImageId", (Object)this.imageId()).add("InstanceType", (Object)this.instanceTypeAsString()).add("KeyName", (Object)this.keyName()).add("Monitoring", (Object)this.monitoring()).add("Placement", (Object)this.placement()).add("RamDiskId", (Object)this.ramDiskId()).add("DisableApiTermination", (Object)this.disableApiTermination()).add("InstanceInitiatedShutdownBehavior", (Object)this.instanceInitiatedShutdownBehaviorAsString()).add("UserData", (Object)this.userData()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("ElasticGpuSpecifications", this.hasElasticGpuSpecifications() ? this.elasticGpuSpecifications() : null).add("ElasticInferenceAccelerators", this.hasElasticInferenceAccelerators() ? this.elasticInferenceAccelerators() : null).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).add("InstanceMarketOptions", (Object)this.instanceMarketOptions()).add("CreditSpecification", (Object)this.creditSpecification()).add("CpuOptions", (Object)this.cpuOptions()).add("CapacityReservationSpecification", (Object)this.capacityReservationSpecification()).add("LicenseSpecifications", this.hasLicenseSpecifications() ? this.licenseSpecifications() : null).add("HibernationOptions", (Object)this.hibernationOptions()).add("MetadataOptions", (Object)this.metadataOptions()).add("EnclaveOptions", (Object)this.enclaveOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KernelId": {
                return Optional.ofNullable(clazz.cast(this.kernelId()));
            }
            case "EbsOptimized": {
                return Optional.ofNullable(clazz.cast(this.ebsOptimized()));
            }
            case "IamInstanceProfile": {
                return Optional.ofNullable(clazz.cast(this.iamInstanceProfile()));
            }
            case "BlockDeviceMappings": {
                return Optional.ofNullable(clazz.cast(this.blockDeviceMappings()));
            }
            case "NetworkInterfaces": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaces()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "KeyName": {
                return Optional.ofNullable(clazz.cast(this.keyName()));
            }
            case "Monitoring": {
                return Optional.ofNullable(clazz.cast(this.monitoring()));
            }
            case "Placement": {
                return Optional.ofNullable(clazz.cast(this.placement()));
            }
            case "RamDiskId": {
                return Optional.ofNullable(clazz.cast(this.ramDiskId()));
            }
            case "DisableApiTermination": {
                return Optional.ofNullable(clazz.cast(this.disableApiTermination()));
            }
            case "InstanceInitiatedShutdownBehavior": {
                return Optional.ofNullable(clazz.cast(this.instanceInitiatedShutdownBehaviorAsString()));
            }
            case "UserData": {
                return Optional.ofNullable(clazz.cast(this.userData()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "ElasticGpuSpecifications": {
                return Optional.ofNullable(clazz.cast(this.elasticGpuSpecifications()));
            }
            case "ElasticInferenceAccelerators": {
                return Optional.ofNullable(clazz.cast(this.elasticInferenceAccelerators()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "InstanceMarketOptions": {
                return Optional.ofNullable(clazz.cast(this.instanceMarketOptions()));
            }
            case "CreditSpecification": {
                return Optional.ofNullable(clazz.cast(this.creditSpecification()));
            }
            case "CpuOptions": {
                return Optional.ofNullable(clazz.cast(this.cpuOptions()));
            }
            case "CapacityReservationSpecification": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationSpecification()));
            }
            case "LicenseSpecifications": {
                return Optional.ofNullable(clazz.cast(this.licenseSpecifications()));
            }
            case "HibernationOptions": {
                return Optional.ofNullable(clazz.cast(this.hibernationOptions()));
            }
            case "MetadataOptions": {
                return Optional.ofNullable(clazz.cast(this.metadataOptions()));
            }
            case "EnclaveOptions": {
                return Optional.ofNullable(clazz.cast(this.enclaveOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RequestLaunchTemplateData, T> g) {
        return obj -> g.apply((RequestLaunchTemplateData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String kernelId;
        private Boolean ebsOptimized;
        private LaunchTemplateIamInstanceProfileSpecificationRequest iamInstanceProfile;
        private List<LaunchTemplateBlockDeviceMappingRequest> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();
        private List<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest> networkInterfaces = DefaultSdkAutoConstructList.getInstance();
        private String imageId;
        private String instanceType;
        private String keyName;
        private LaunchTemplatesMonitoringRequest monitoring;
        private LaunchTemplatePlacementRequest placement;
        private String ramDiskId;
        private Boolean disableApiTermination;
        private String instanceInitiatedShutdownBehavior;
        private String userData;
        private List<LaunchTemplateTagSpecificationRequest> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private List<ElasticGpuSpecification> elasticGpuSpecifications = DefaultSdkAutoConstructList.getInstance();
        private List<LaunchTemplateElasticInferenceAccelerator> elasticInferenceAccelerators = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private LaunchTemplateInstanceMarketOptionsRequest instanceMarketOptions;
        private CreditSpecificationRequest creditSpecification;
        private LaunchTemplateCpuOptionsRequest cpuOptions;
        private LaunchTemplateCapacityReservationSpecificationRequest capacityReservationSpecification;
        private List<LaunchTemplateLicenseConfigurationRequest> licenseSpecifications = DefaultSdkAutoConstructList.getInstance();
        private LaunchTemplateHibernationOptionsRequest hibernationOptions;
        private LaunchTemplateInstanceMetadataOptionsRequest metadataOptions;
        private LaunchTemplateEnclaveOptionsRequest enclaveOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestLaunchTemplateData model) {
            this.kernelId(model.kernelId);
            this.ebsOptimized(model.ebsOptimized);
            this.iamInstanceProfile(model.iamInstanceProfile);
            this.blockDeviceMappings(model.blockDeviceMappings);
            this.networkInterfaces(model.networkInterfaces);
            this.imageId(model.imageId);
            this.instanceType(model.instanceType);
            this.keyName(model.keyName);
            this.monitoring(model.monitoring);
            this.placement(model.placement);
            this.ramDiskId(model.ramDiskId);
            this.disableApiTermination(model.disableApiTermination);
            this.instanceInitiatedShutdownBehavior(model.instanceInitiatedShutdownBehavior);
            this.userData(model.userData);
            this.tagSpecifications(model.tagSpecifications);
            this.elasticGpuSpecifications(model.elasticGpuSpecifications);
            this.elasticInferenceAccelerators(model.elasticInferenceAccelerators);
            this.securityGroupIds(model.securityGroupIds);
            this.securityGroups(model.securityGroups);
            this.instanceMarketOptions(model.instanceMarketOptions);
            this.creditSpecification(model.creditSpecification);
            this.cpuOptions(model.cpuOptions);
            this.capacityReservationSpecification(model.capacityReservationSpecification);
            this.licenseSpecifications(model.licenseSpecifications);
            this.hibernationOptions(model.hibernationOptions);
            this.metadataOptions(model.metadataOptions);
            this.enclaveOptions(model.enclaveOptions);
        }

        public final String getKernelId() {
            return this.kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final LaunchTemplateIamInstanceProfileSpecificationRequest.Builder getIamInstanceProfile() {
            return this.iamInstanceProfile != null ? this.iamInstanceProfile.toBuilder() : null;
        }

        @Override
        public final Builder iamInstanceProfile(LaunchTemplateIamInstanceProfileSpecificationRequest iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final void setIamInstanceProfile(LaunchTemplateIamInstanceProfileSpecificationRequest.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        public final List<LaunchTemplateBlockDeviceMappingRequest.Builder> getBlockDeviceMappings() {
            List<LaunchTemplateBlockDeviceMappingRequest.Builder> result = LaunchTemplateBlockDeviceMappingRequestListCopier.copyToBuilder(this.blockDeviceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<LaunchTemplateBlockDeviceMappingRequest> blockDeviceMappings) {
            this.blockDeviceMappings = LaunchTemplateBlockDeviceMappingRequestListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(LaunchTemplateBlockDeviceMappingRequest ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<LaunchTemplateBlockDeviceMappingRequest.Builder> ... blockDeviceMappings) {
            this.blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> (LaunchTemplateBlockDeviceMappingRequest)((LaunchTemplateBlockDeviceMappingRequest.Builder)LaunchTemplateBlockDeviceMappingRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<LaunchTemplateBlockDeviceMappingRequest.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = LaunchTemplateBlockDeviceMappingRequestListCopier.copyFromBuilder(blockDeviceMappings);
        }

        public final List<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest.Builder> getNetworkInterfaces() {
            List<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest.Builder> result = LaunchTemplateInstanceNetworkInterfaceSpecificationRequestListCopier.copyToBuilder(this.networkInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder networkInterfaces(Collection<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest> networkInterfaces) {
            this.networkInterfaces = LaunchTemplateInstanceNetworkInterfaceSpecificationRequestListCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest ... networkInterfaces) {
            this.networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(Consumer<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest.Builder> ... networkInterfaces) {
            this.networkInterfaces(Stream.of(networkInterfaces).map(c -> (LaunchTemplateInstanceNetworkInterfaceSpecificationRequest)((LaunchTemplateInstanceNetworkInterfaceSpecificationRequest.Builder)LaunchTemplateInstanceNetworkInterfaceSpecificationRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNetworkInterfaces(Collection<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = LaunchTemplateInstanceNetworkInterfaceSpecificationRequestListCopier.copyFromBuilder(networkInterfaces);
        }

        public final String getImageId() {
            return this.imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKeyName() {
            return this.keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public final LaunchTemplatesMonitoringRequest.Builder getMonitoring() {
            return this.monitoring != null ? this.monitoring.toBuilder() : null;
        }

        @Override
        public final Builder monitoring(LaunchTemplatesMonitoringRequest monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final void setMonitoring(LaunchTemplatesMonitoringRequest.BuilderImpl monitoring) {
            this.monitoring = monitoring != null ? monitoring.build() : null;
        }

        public final LaunchTemplatePlacementRequest.Builder getPlacement() {
            return this.placement != null ? this.placement.toBuilder() : null;
        }

        @Override
        public final Builder placement(LaunchTemplatePlacementRequest placement) {
            this.placement = placement;
            return this;
        }

        public final void setPlacement(LaunchTemplatePlacementRequest.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        public final String getRamDiskId() {
            return this.ramDiskId;
        }

        @Override
        public final Builder ramDiskId(String ramDiskId) {
            this.ramDiskId = ramDiskId;
            return this;
        }

        public final void setRamDiskId(String ramDiskId) {
            this.ramDiskId = ramDiskId;
        }

        public final Boolean getDisableApiTermination() {
            return this.disableApiTermination;
        }

        @Override
        public final Builder disableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
            return this;
        }

        public final void setDisableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
        }

        public final String getInstanceInitiatedShutdownBehavior() {
            return this.instanceInitiatedShutdownBehavior;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            return this;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(ShutdownBehavior instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior == null ? null : instanceInitiatedShutdownBehavior.toString());
            return this;
        }

        public final void setInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
        }

        public final String getUserData() {
            return this.userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        public final List<LaunchTemplateTagSpecificationRequest.Builder> getTagSpecifications() {
            List<LaunchTemplateTagSpecificationRequest.Builder> result = LaunchTemplateTagSpecificationRequestListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tagSpecifications(Collection<LaunchTemplateTagSpecificationRequest> tagSpecifications) {
            this.tagSpecifications = LaunchTemplateTagSpecificationRequestListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(LaunchTemplateTagSpecificationRequest ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<LaunchTemplateTagSpecificationRequest.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (LaunchTemplateTagSpecificationRequest)((LaunchTemplateTagSpecificationRequest.Builder)LaunchTemplateTagSpecificationRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagSpecifications(Collection<LaunchTemplateTagSpecificationRequest.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = LaunchTemplateTagSpecificationRequestListCopier.copyFromBuilder(tagSpecifications);
        }

        public final List<ElasticGpuSpecification.Builder> getElasticGpuSpecifications() {
            List<ElasticGpuSpecification.Builder> result = ElasticGpuSpecificationListCopier.copyToBuilder(this.elasticGpuSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder elasticGpuSpecifications(Collection<ElasticGpuSpecification> elasticGpuSpecifications) {
            this.elasticGpuSpecifications = ElasticGpuSpecificationListCopier.copy(elasticGpuSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticGpuSpecifications(ElasticGpuSpecification ... elasticGpuSpecifications) {
            this.elasticGpuSpecifications(Arrays.asList(elasticGpuSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticGpuSpecifications(Consumer<ElasticGpuSpecification.Builder> ... elasticGpuSpecifications) {
            this.elasticGpuSpecifications(Stream.of(elasticGpuSpecifications).map(c -> (ElasticGpuSpecification)((ElasticGpuSpecification.Builder)ElasticGpuSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setElasticGpuSpecifications(Collection<ElasticGpuSpecification.BuilderImpl> elasticGpuSpecifications) {
            this.elasticGpuSpecifications = ElasticGpuSpecificationListCopier.copyFromBuilder(elasticGpuSpecifications);
        }

        public final List<LaunchTemplateElasticInferenceAccelerator.Builder> getElasticInferenceAccelerators() {
            List<LaunchTemplateElasticInferenceAccelerator.Builder> result = LaunchTemplateElasticInferenceAcceleratorListCopier.copyToBuilder(this.elasticInferenceAccelerators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder elasticInferenceAccelerators(Collection<LaunchTemplateElasticInferenceAccelerator> elasticInferenceAccelerators) {
            this.elasticInferenceAccelerators = LaunchTemplateElasticInferenceAcceleratorListCopier.copy(elasticInferenceAccelerators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticInferenceAccelerators(LaunchTemplateElasticInferenceAccelerator ... elasticInferenceAccelerators) {
            this.elasticInferenceAccelerators(Arrays.asList(elasticInferenceAccelerators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticInferenceAccelerators(Consumer<LaunchTemplateElasticInferenceAccelerator.Builder> ... elasticInferenceAccelerators) {
            this.elasticInferenceAccelerators(Stream.of(elasticInferenceAccelerators).map(c -> (LaunchTemplateElasticInferenceAccelerator)((LaunchTemplateElasticInferenceAccelerator.Builder)LaunchTemplateElasticInferenceAccelerator.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setElasticInferenceAccelerators(Collection<LaunchTemplateElasticInferenceAccelerator.BuilderImpl> elasticInferenceAccelerators) {
            this.elasticInferenceAccelerators = LaunchTemplateElasticInferenceAcceleratorListCopier.copyFromBuilder(elasticInferenceAccelerators);
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdStringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdStringListCopier.copy(securityGroupIds);
        }

        public final Collection<String> getSecurityGroups() {
            if (this.securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupStringListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupStringListCopier.copy(securityGroups);
        }

        public final LaunchTemplateInstanceMarketOptionsRequest.Builder getInstanceMarketOptions() {
            return this.instanceMarketOptions != null ? this.instanceMarketOptions.toBuilder() : null;
        }

        @Override
        public final Builder instanceMarketOptions(LaunchTemplateInstanceMarketOptionsRequest instanceMarketOptions) {
            this.instanceMarketOptions = instanceMarketOptions;
            return this;
        }

        public final void setInstanceMarketOptions(LaunchTemplateInstanceMarketOptionsRequest.BuilderImpl instanceMarketOptions) {
            this.instanceMarketOptions = instanceMarketOptions != null ? instanceMarketOptions.build() : null;
        }

        public final CreditSpecificationRequest.Builder getCreditSpecification() {
            return this.creditSpecification != null ? this.creditSpecification.toBuilder() : null;
        }

        @Override
        public final Builder creditSpecification(CreditSpecificationRequest creditSpecification) {
            this.creditSpecification = creditSpecification;
            return this;
        }

        public final void setCreditSpecification(CreditSpecificationRequest.BuilderImpl creditSpecification) {
            this.creditSpecification = creditSpecification != null ? creditSpecification.build() : null;
        }

        public final LaunchTemplateCpuOptionsRequest.Builder getCpuOptions() {
            return this.cpuOptions != null ? this.cpuOptions.toBuilder() : null;
        }

        @Override
        public final Builder cpuOptions(LaunchTemplateCpuOptionsRequest cpuOptions) {
            this.cpuOptions = cpuOptions;
            return this;
        }

        public final void setCpuOptions(LaunchTemplateCpuOptionsRequest.BuilderImpl cpuOptions) {
            this.cpuOptions = cpuOptions != null ? cpuOptions.build() : null;
        }

        public final LaunchTemplateCapacityReservationSpecificationRequest.Builder getCapacityReservationSpecification() {
            return this.capacityReservationSpecification != null ? this.capacityReservationSpecification.toBuilder() : null;
        }

        @Override
        public final Builder capacityReservationSpecification(LaunchTemplateCapacityReservationSpecificationRequest capacityReservationSpecification) {
            this.capacityReservationSpecification = capacityReservationSpecification;
            return this;
        }

        public final void setCapacityReservationSpecification(LaunchTemplateCapacityReservationSpecificationRequest.BuilderImpl capacityReservationSpecification) {
            this.capacityReservationSpecification = capacityReservationSpecification != null ? capacityReservationSpecification.build() : null;
        }

        public final List<LaunchTemplateLicenseConfigurationRequest.Builder> getLicenseSpecifications() {
            List<LaunchTemplateLicenseConfigurationRequest.Builder> result = LaunchTemplateLicenseSpecificationListRequestCopier.copyToBuilder(this.licenseSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder licenseSpecifications(Collection<LaunchTemplateLicenseConfigurationRequest> licenseSpecifications) {
            this.licenseSpecifications = LaunchTemplateLicenseSpecificationListRequestCopier.copy(licenseSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseSpecifications(LaunchTemplateLicenseConfigurationRequest ... licenseSpecifications) {
            this.licenseSpecifications(Arrays.asList(licenseSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseSpecifications(Consumer<LaunchTemplateLicenseConfigurationRequest.Builder> ... licenseSpecifications) {
            this.licenseSpecifications(Stream.of(licenseSpecifications).map(c -> (LaunchTemplateLicenseConfigurationRequest)((LaunchTemplateLicenseConfigurationRequest.Builder)LaunchTemplateLicenseConfigurationRequest.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLicenseSpecifications(Collection<LaunchTemplateLicenseConfigurationRequest.BuilderImpl> licenseSpecifications) {
            this.licenseSpecifications = LaunchTemplateLicenseSpecificationListRequestCopier.copyFromBuilder(licenseSpecifications);
        }

        public final LaunchTemplateHibernationOptionsRequest.Builder getHibernationOptions() {
            return this.hibernationOptions != null ? this.hibernationOptions.toBuilder() : null;
        }

        @Override
        public final Builder hibernationOptions(LaunchTemplateHibernationOptionsRequest hibernationOptions) {
            this.hibernationOptions = hibernationOptions;
            return this;
        }

        public final void setHibernationOptions(LaunchTemplateHibernationOptionsRequest.BuilderImpl hibernationOptions) {
            this.hibernationOptions = hibernationOptions != null ? hibernationOptions.build() : null;
        }

        public final LaunchTemplateInstanceMetadataOptionsRequest.Builder getMetadataOptions() {
            return this.metadataOptions != null ? this.metadataOptions.toBuilder() : null;
        }

        @Override
        public final Builder metadataOptions(LaunchTemplateInstanceMetadataOptionsRequest metadataOptions) {
            this.metadataOptions = metadataOptions;
            return this;
        }

        public final void setMetadataOptions(LaunchTemplateInstanceMetadataOptionsRequest.BuilderImpl metadataOptions) {
            this.metadataOptions = metadataOptions != null ? metadataOptions.build() : null;
        }

        public final LaunchTemplateEnclaveOptionsRequest.Builder getEnclaveOptions() {
            return this.enclaveOptions != null ? this.enclaveOptions.toBuilder() : null;
        }

        @Override
        public final Builder enclaveOptions(LaunchTemplateEnclaveOptionsRequest enclaveOptions) {
            this.enclaveOptions = enclaveOptions;
            return this;
        }

        public final void setEnclaveOptions(LaunchTemplateEnclaveOptionsRequest.BuilderImpl enclaveOptions) {
            this.enclaveOptions = enclaveOptions != null ? enclaveOptions.build() : null;
        }

        public RequestLaunchTemplateData build() {
            return new RequestLaunchTemplateData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RequestLaunchTemplateData> {
        public Builder kernelId(String var1);

        public Builder ebsOptimized(Boolean var1);

        public Builder iamInstanceProfile(LaunchTemplateIamInstanceProfileSpecificationRequest var1);

        default public Builder iamInstanceProfile(Consumer<LaunchTemplateIamInstanceProfileSpecificationRequest.Builder> iamInstanceProfile) {
            return this.iamInstanceProfile((LaunchTemplateIamInstanceProfileSpecificationRequest)((LaunchTemplateIamInstanceProfileSpecificationRequest.Builder)LaunchTemplateIamInstanceProfileSpecificationRequest.builder().applyMutation(iamInstanceProfile)).build());
        }

        public Builder blockDeviceMappings(Collection<LaunchTemplateBlockDeviceMappingRequest> var1);

        public Builder blockDeviceMappings(LaunchTemplateBlockDeviceMappingRequest ... var1);

        public Builder blockDeviceMappings(Consumer<LaunchTemplateBlockDeviceMappingRequest.Builder> ... var1);

        public Builder networkInterfaces(Collection<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest> var1);

        public Builder networkInterfaces(LaunchTemplateInstanceNetworkInterfaceSpecificationRequest ... var1);

        public Builder networkInterfaces(Consumer<LaunchTemplateInstanceNetworkInterfaceSpecificationRequest.Builder> ... var1);

        public Builder imageId(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder keyName(String var1);

        public Builder monitoring(LaunchTemplatesMonitoringRequest var1);

        default public Builder monitoring(Consumer<LaunchTemplatesMonitoringRequest.Builder> monitoring) {
            return this.monitoring((LaunchTemplatesMonitoringRequest)((LaunchTemplatesMonitoringRequest.Builder)LaunchTemplatesMonitoringRequest.builder().applyMutation(monitoring)).build());
        }

        public Builder placement(LaunchTemplatePlacementRequest var1);

        default public Builder placement(Consumer<LaunchTemplatePlacementRequest.Builder> placement) {
            return this.placement((LaunchTemplatePlacementRequest)((LaunchTemplatePlacementRequest.Builder)LaunchTemplatePlacementRequest.builder().applyMutation(placement)).build());
        }

        public Builder ramDiskId(String var1);

        public Builder disableApiTermination(Boolean var1);

        public Builder instanceInitiatedShutdownBehavior(String var1);

        public Builder instanceInitiatedShutdownBehavior(ShutdownBehavior var1);

        public Builder userData(String var1);

        public Builder tagSpecifications(Collection<LaunchTemplateTagSpecificationRequest> var1);

        public Builder tagSpecifications(LaunchTemplateTagSpecificationRequest ... var1);

        public Builder tagSpecifications(Consumer<LaunchTemplateTagSpecificationRequest.Builder> ... var1);

        public Builder elasticGpuSpecifications(Collection<ElasticGpuSpecification> var1);

        public Builder elasticGpuSpecifications(ElasticGpuSpecification ... var1);

        public Builder elasticGpuSpecifications(Consumer<ElasticGpuSpecification.Builder> ... var1);

        public Builder elasticInferenceAccelerators(Collection<LaunchTemplateElasticInferenceAccelerator> var1);

        public Builder elasticInferenceAccelerators(LaunchTemplateElasticInferenceAccelerator ... var1);

        public Builder elasticInferenceAccelerators(Consumer<LaunchTemplateElasticInferenceAccelerator.Builder> ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder instanceMarketOptions(LaunchTemplateInstanceMarketOptionsRequest var1);

        default public Builder instanceMarketOptions(Consumer<LaunchTemplateInstanceMarketOptionsRequest.Builder> instanceMarketOptions) {
            return this.instanceMarketOptions((LaunchTemplateInstanceMarketOptionsRequest)((LaunchTemplateInstanceMarketOptionsRequest.Builder)LaunchTemplateInstanceMarketOptionsRequest.builder().applyMutation(instanceMarketOptions)).build());
        }

        public Builder creditSpecification(CreditSpecificationRequest var1);

        default public Builder creditSpecification(Consumer<CreditSpecificationRequest.Builder> creditSpecification) {
            return this.creditSpecification((CreditSpecificationRequest)((CreditSpecificationRequest.Builder)CreditSpecificationRequest.builder().applyMutation(creditSpecification)).build());
        }

        public Builder cpuOptions(LaunchTemplateCpuOptionsRequest var1);

        default public Builder cpuOptions(Consumer<LaunchTemplateCpuOptionsRequest.Builder> cpuOptions) {
            return this.cpuOptions((LaunchTemplateCpuOptionsRequest)((LaunchTemplateCpuOptionsRequest.Builder)LaunchTemplateCpuOptionsRequest.builder().applyMutation(cpuOptions)).build());
        }

        public Builder capacityReservationSpecification(LaunchTemplateCapacityReservationSpecificationRequest var1);

        default public Builder capacityReservationSpecification(Consumer<LaunchTemplateCapacityReservationSpecificationRequest.Builder> capacityReservationSpecification) {
            return this.capacityReservationSpecification((LaunchTemplateCapacityReservationSpecificationRequest)((LaunchTemplateCapacityReservationSpecificationRequest.Builder)LaunchTemplateCapacityReservationSpecificationRequest.builder().applyMutation(capacityReservationSpecification)).build());
        }

        public Builder licenseSpecifications(Collection<LaunchTemplateLicenseConfigurationRequest> var1);

        public Builder licenseSpecifications(LaunchTemplateLicenseConfigurationRequest ... var1);

        public Builder licenseSpecifications(Consumer<LaunchTemplateLicenseConfigurationRequest.Builder> ... var1);

        public Builder hibernationOptions(LaunchTemplateHibernationOptionsRequest var1);

        default public Builder hibernationOptions(Consumer<LaunchTemplateHibernationOptionsRequest.Builder> hibernationOptions) {
            return this.hibernationOptions((LaunchTemplateHibernationOptionsRequest)((LaunchTemplateHibernationOptionsRequest.Builder)LaunchTemplateHibernationOptionsRequest.builder().applyMutation(hibernationOptions)).build());
        }

        public Builder metadataOptions(LaunchTemplateInstanceMetadataOptionsRequest var1);

        default public Builder metadataOptions(Consumer<LaunchTemplateInstanceMetadataOptionsRequest.Builder> metadataOptions) {
            return this.metadataOptions((LaunchTemplateInstanceMetadataOptionsRequest)((LaunchTemplateInstanceMetadataOptionsRequest.Builder)LaunchTemplateInstanceMetadataOptionsRequest.builder().applyMutation(metadataOptions)).build());
        }

        public Builder enclaveOptions(LaunchTemplateEnclaveOptionsRequest var1);

        default public Builder enclaveOptions(Consumer<LaunchTemplateEnclaveOptionsRequest.Builder> enclaveOptions) {
            return this.enclaveOptions((LaunchTemplateEnclaveOptionsRequest)((LaunchTemplateEnclaveOptionsRequest.Builder)LaunchTemplateEnclaveOptionsRequest.builder().applyMutation(enclaveOptions)).build());
        }
    }
}

