/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDhcpOptionsRequest extends Ec2Request implements
        ToCopyableBuilder<CreateDhcpOptionsRequest.Builder, CreateDhcpOptionsRequest> {
    private static final SdkField<List<NewDhcpConfiguration>> DHCP_CONFIGURATIONS_FIELD = SdkField
            .<List<NewDhcpConfiguration>> builder(MarshallingType.LIST)
            .memberName("DhcpConfigurations")
            .getter(getter(CreateDhcpOptionsRequest::dhcpConfigurations))
            .setter(setter(Builder::dhcpConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DhcpConfiguration")
                    .unmarshallLocationName("dhcpConfiguration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<NewDhcpConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(NewDhcpConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField
            .<List<TagSpecification>> builder(MarshallingType.LIST)
            .memberName("TagSpecifications")
            .getter(getter(CreateDhcpOptionsRequest::tagSpecifications))
            .setter(setter(Builder::tagSpecifications))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification")
                    .unmarshallLocationName("TagSpecification").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<TagSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(TagSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DHCP_CONFIGURATIONS_FIELD,
            TAG_SPECIFICATIONS_FIELD));

    private final List<NewDhcpConfiguration> dhcpConfigurations;

    private final List<TagSpecification> tagSpecifications;

    private CreateDhcpOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.dhcpConfigurations = builder.dhcpConfigurations;
        this.tagSpecifications = builder.tagSpecifications;
    }

    /**
     * Returns true if the DhcpConfigurations property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasDhcpConfigurations() {
        return dhcpConfigurations != null && !(dhcpConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A DHCP configuration option.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDhcpConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A DHCP configuration option.
     */
    public final List<NewDhcpConfiguration> dhcpConfigurations() {
        return dhcpConfigurations;
    }

    /**
     * Returns true if the TagSpecifications property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasTagSpecifications() {
        return tagSpecifications != null && !(tagSpecifications instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to assign to the DHCP option.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTagSpecifications()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags to assign to the DHCP option.
     */
    public final List<TagSpecification> tagSpecifications() {
        return tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDhcpConfigurations() ? dhcpConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSpecifications() ? tagSpecifications() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDhcpOptionsRequest)) {
            return false;
        }
        CreateDhcpOptionsRequest other = (CreateDhcpOptionsRequest) obj;
        return hasDhcpConfigurations() == other.hasDhcpConfigurations()
                && Objects.equals(dhcpConfigurations(), other.dhcpConfigurations())
                && hasTagSpecifications() == other.hasTagSpecifications()
                && Objects.equals(tagSpecifications(), other.tagSpecifications());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDhcpOptionsRequest")
                .add("DhcpConfigurations", hasDhcpConfigurations() ? dhcpConfigurations() : null)
                .add("TagSpecifications", hasTagSpecifications() ? tagSpecifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DhcpConfigurations":
            return Optional.ofNullable(clazz.cast(dhcpConfigurations()));
        case "TagSpecifications":
            return Optional.ofNullable(clazz.cast(tagSpecifications()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDhcpOptionsRequest, T> g) {
        return obj -> g.apply((CreateDhcpOptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateDhcpOptionsRequest> {
        /**
         * <p>
         * A DHCP configuration option.
         * </p>
         * 
         * @param dhcpConfigurations
         *        A DHCP configuration option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dhcpConfigurations(Collection<NewDhcpConfiguration> dhcpConfigurations);

        /**
         * <p>
         * A DHCP configuration option.
         * </p>
         * 
         * @param dhcpConfigurations
         *        A DHCP configuration option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dhcpConfigurations(NewDhcpConfiguration... dhcpConfigurations);

        /**
         * <p>
         * A DHCP configuration option.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NewDhcpConfiguration>.Builder} avoiding the
         * need to create one manually via {@link List<NewDhcpConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NewDhcpConfiguration>.Builder#build()} is called immediately
         * and its result is passed to {@link #dhcpConfigurations(List<NewDhcpConfiguration>)}.
         * 
         * @param dhcpConfigurations
         *        a consumer that will call methods on {@link List<NewDhcpConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dhcpConfigurations(List<NewDhcpConfiguration>)
         */
        Builder dhcpConfigurations(Consumer<NewDhcpConfiguration.Builder>... dhcpConfigurations);

        /**
         * <p>
         * The tags to assign to the DHCP option.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to assign to the DHCP option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(Collection<TagSpecification> tagSpecifications);

        /**
         * <p>
         * The tags to assign to the DHCP option.
         * </p>
         * 
         * @param tagSpecifications
         *        The tags to assign to the DHCP option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSpecifications(TagSpecification... tagSpecifications);

        /**
         * <p>
         * The tags to assign to the DHCP option.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TagSpecification>.Builder} avoiding the
         * need to create one manually via {@link List<TagSpecification>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TagSpecification>.Builder#build()} is called immediately and
         * its result is passed to {@link #tagSpecifications(List<TagSpecification>)}.
         * 
         * @param tagSpecifications
         *        a consumer that will call methods on {@link List<TagSpecification>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSpecifications(List<TagSpecification>)
         */
        Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private List<NewDhcpConfiguration> dhcpConfigurations = DefaultSdkAutoConstructList.getInstance();

        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDhcpOptionsRequest model) {
            super(model);
            dhcpConfigurations(model.dhcpConfigurations);
            tagSpecifications(model.tagSpecifications);
        }

        public final Collection<NewDhcpConfiguration.Builder> getDhcpConfigurations() {
            if (dhcpConfigurations instanceof SdkAutoConstructList) {
                return null;
            }
            return dhcpConfigurations != null ? dhcpConfigurations.stream().map(NewDhcpConfiguration::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dhcpConfigurations(Collection<NewDhcpConfiguration> dhcpConfigurations) {
            this.dhcpConfigurations = NewDhcpConfigurationListCopier.copy(dhcpConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dhcpConfigurations(NewDhcpConfiguration... dhcpConfigurations) {
            dhcpConfigurations(Arrays.asList(dhcpConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dhcpConfigurations(Consumer<NewDhcpConfiguration.Builder>... dhcpConfigurations) {
            dhcpConfigurations(Stream.of(dhcpConfigurations).map(c -> NewDhcpConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDhcpConfigurations(Collection<NewDhcpConfiguration.BuilderImpl> dhcpConfigurations) {
            this.dhcpConfigurations = NewDhcpConfigurationListCopier.copyFromBuilder(dhcpConfigurations);
        }

        public final Collection<TagSpecification.Builder> getTagSpecifications() {
            if (tagSpecifications instanceof SdkAutoConstructList) {
                return null;
            }
            return tagSpecifications != null ? tagSpecifications.stream().map(TagSpecification::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification... tagSpecifications) {
            tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder>... tagSpecifications) {
            tagSpecifications(Stream.of(tagSpecifications).map(c -> TagSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDhcpOptionsRequest build() {
            return new CreateDhcpOptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
