/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRule;
import software.amazon.awssdk.services.ec2.model.TrafficMirrorFilterRuleListCopier;
import software.amazon.awssdk.services.ec2.model.TrafficMirrorNetworkService;
import software.amazon.awssdk.services.ec2.model.TrafficMirrorNetworkServiceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrafficMirrorFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrafficMirrorFilter> {
    private static final SdkField<String> TRAFFIC_MIRROR_FILTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficMirrorFilterId").getter(TrafficMirrorFilter.getter(TrafficMirrorFilter::trafficMirrorFilterId)).setter(TrafficMirrorFilter.setter(Builder::trafficMirrorFilterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorFilterId").unmarshallLocationName("trafficMirrorFilterId").build()}).build();
    private static final SdkField<List<TrafficMirrorFilterRule>> INGRESS_FILTER_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IngressFilterRules").getter(TrafficMirrorFilter.getter(TrafficMirrorFilter::ingressFilterRules)).setter(TrafficMirrorFilter.setter(Builder::ingressFilterRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngressFilterRuleSet").unmarshallLocationName("ingressFilterRuleSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrafficMirrorFilterRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<TrafficMirrorFilterRule>> EGRESS_FILTER_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EgressFilterRules").getter(TrafficMirrorFilter.getter(TrafficMirrorFilter::egressFilterRules)).setter(TrafficMirrorFilter.setter(Builder::egressFilterRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EgressFilterRuleSet").unmarshallLocationName("egressFilterRuleSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrafficMirrorFilterRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NETWORK_SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkServices").getter(TrafficMirrorFilter.getter(TrafficMirrorFilter::networkServicesAsStrings)).setter(TrafficMirrorFilter.setter(Builder::networkServicesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkServiceSet").unmarshallLocationName("networkServiceSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(TrafficMirrorFilter.getter(TrafficMirrorFilter::description)).setter(TrafficMirrorFilter.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(TrafficMirrorFilter.getter(TrafficMirrorFilter::tags)).setter(TrafficMirrorFilter.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_MIRROR_FILTER_ID_FIELD, INGRESS_FILTER_RULES_FIELD, EGRESS_FILTER_RULES_FIELD, NETWORK_SERVICES_FIELD, DESCRIPTION_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String trafficMirrorFilterId;
    private final List<TrafficMirrorFilterRule> ingressFilterRules;
    private final List<TrafficMirrorFilterRule> egressFilterRules;
    private final List<String> networkServices;
    private final String description;
    private final List<Tag> tags;

    private TrafficMirrorFilter(BuilderImpl builder) {
        this.trafficMirrorFilterId = builder.trafficMirrorFilterId;
        this.ingressFilterRules = builder.ingressFilterRules;
        this.egressFilterRules = builder.egressFilterRules;
        this.networkServices = builder.networkServices;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    public String trafficMirrorFilterId() {
        return this.trafficMirrorFilterId;
    }

    public boolean hasIngressFilterRules() {
        return this.ingressFilterRules != null && !(this.ingressFilterRules instanceof SdkAutoConstructList);
    }

    public List<TrafficMirrorFilterRule> ingressFilterRules() {
        return this.ingressFilterRules;
    }

    public boolean hasEgressFilterRules() {
        return this.egressFilterRules != null && !(this.egressFilterRules instanceof SdkAutoConstructList);
    }

    public List<TrafficMirrorFilterRule> egressFilterRules() {
        return this.egressFilterRules;
    }

    public List<TrafficMirrorNetworkService> networkServices() {
        return TrafficMirrorNetworkServiceListCopier.copyStringToEnum(this.networkServices);
    }

    public boolean hasNetworkServices() {
        return this.networkServices != null && !(this.networkServices instanceof SdkAutoConstructList);
    }

    public List<String> networkServicesAsStrings() {
        return this.networkServices;
    }

    public String description() {
        return this.description;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficMirrorFilterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingressFilterRules());
        hashCode = 31 * hashCode + Objects.hashCode(this.egressFilterRules());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkServicesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficMirrorFilter)) {
            return false;
        }
        TrafficMirrorFilter other = (TrafficMirrorFilter)obj;
        return Objects.equals(this.trafficMirrorFilterId(), other.trafficMirrorFilterId()) && Objects.equals(this.ingressFilterRules(), other.ingressFilterRules()) && Objects.equals(this.egressFilterRules(), other.egressFilterRules()) && Objects.equals(this.networkServicesAsStrings(), other.networkServicesAsStrings()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"TrafficMirrorFilter").add("TrafficMirrorFilterId", (Object)this.trafficMirrorFilterId()).add("IngressFilterRules", this.ingressFilterRules()).add("EgressFilterRules", this.egressFilterRules()).add("NetworkServices", this.networkServicesAsStrings()).add("Description", (Object)this.description()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrafficMirrorFilterId": {
                return Optional.ofNullable(clazz.cast(this.trafficMirrorFilterId()));
            }
            case "IngressFilterRules": {
                return Optional.ofNullable(clazz.cast(this.ingressFilterRules()));
            }
            case "EgressFilterRules": {
                return Optional.ofNullable(clazz.cast(this.egressFilterRules()));
            }
            case "NetworkServices": {
                return Optional.ofNullable(clazz.cast(this.networkServicesAsStrings()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrafficMirrorFilter, T> g) {
        return obj -> g.apply((TrafficMirrorFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String trafficMirrorFilterId;
        private List<TrafficMirrorFilterRule> ingressFilterRules = DefaultSdkAutoConstructList.getInstance();
        private List<TrafficMirrorFilterRule> egressFilterRules = DefaultSdkAutoConstructList.getInstance();
        private List<String> networkServices = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TrafficMirrorFilter model) {
            this.trafficMirrorFilterId(model.trafficMirrorFilterId);
            this.ingressFilterRules(model.ingressFilterRules);
            this.egressFilterRules(model.egressFilterRules);
            this.networkServicesWithStrings(model.networkServices);
            this.description(model.description);
            this.tags(model.tags);
        }

        public final String getTrafficMirrorFilterId() {
            return this.trafficMirrorFilterId;
        }

        @Override
        public final Builder trafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
            return this;
        }

        public final void setTrafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
        }

        public final Collection<TrafficMirrorFilterRule.Builder> getIngressFilterRules() {
            return this.ingressFilterRules != null ? (Collection)this.ingressFilterRules.stream().map(TrafficMirrorFilterRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ingressFilterRules(Collection<TrafficMirrorFilterRule> ingressFilterRules) {
            this.ingressFilterRules = TrafficMirrorFilterRuleListCopier.copy(ingressFilterRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingressFilterRules(TrafficMirrorFilterRule ... ingressFilterRules) {
            this.ingressFilterRules(Arrays.asList(ingressFilterRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ingressFilterRules(Consumer<TrafficMirrorFilterRule.Builder> ... ingressFilterRules) {
            this.ingressFilterRules(Stream.of(ingressFilterRules).map(c -> (TrafficMirrorFilterRule)((TrafficMirrorFilterRule.Builder)TrafficMirrorFilterRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIngressFilterRules(Collection<TrafficMirrorFilterRule.BuilderImpl> ingressFilterRules) {
            this.ingressFilterRules = TrafficMirrorFilterRuleListCopier.copyFromBuilder(ingressFilterRules);
        }

        public final Collection<TrafficMirrorFilterRule.Builder> getEgressFilterRules() {
            return this.egressFilterRules != null ? (Collection)this.egressFilterRules.stream().map(TrafficMirrorFilterRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder egressFilterRules(Collection<TrafficMirrorFilterRule> egressFilterRules) {
            this.egressFilterRules = TrafficMirrorFilterRuleListCopier.copy(egressFilterRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder egressFilterRules(TrafficMirrorFilterRule ... egressFilterRules) {
            this.egressFilterRules(Arrays.asList(egressFilterRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder egressFilterRules(Consumer<TrafficMirrorFilterRule.Builder> ... egressFilterRules) {
            this.egressFilterRules(Stream.of(egressFilterRules).map(c -> (TrafficMirrorFilterRule)((TrafficMirrorFilterRule.Builder)TrafficMirrorFilterRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEgressFilterRules(Collection<TrafficMirrorFilterRule.BuilderImpl> egressFilterRules) {
            this.egressFilterRules = TrafficMirrorFilterRuleListCopier.copyFromBuilder(egressFilterRules);
        }

        public final Collection<String> getNetworkServices() {
            return this.networkServices;
        }

        @Override
        public final Builder networkServicesWithStrings(Collection<String> networkServices) {
            this.networkServices = TrafficMirrorNetworkServiceListCopier.copy(networkServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkServicesWithStrings(String ... networkServices) {
            this.networkServicesWithStrings(Arrays.asList(networkServices));
            return this;
        }

        @Override
        public final Builder networkServices(Collection<TrafficMirrorNetworkService> networkServices) {
            this.networkServices = TrafficMirrorNetworkServiceListCopier.copyEnumToString(networkServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkServices(TrafficMirrorNetworkService ... networkServices) {
            this.networkServices(Arrays.asList(networkServices));
            return this;
        }

        public final void setNetworkServices(Collection<String> networkServices) {
            this.networkServices = TrafficMirrorNetworkServiceListCopier.copy(networkServices);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public TrafficMirrorFilter build() {
            return new TrafficMirrorFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrafficMirrorFilter> {
        public Builder trafficMirrorFilterId(String var1);

        public Builder ingressFilterRules(Collection<TrafficMirrorFilterRule> var1);

        public Builder ingressFilterRules(TrafficMirrorFilterRule ... var1);

        public Builder ingressFilterRules(Consumer<TrafficMirrorFilterRule.Builder> ... var1);

        public Builder egressFilterRules(Collection<TrafficMirrorFilterRule> var1);

        public Builder egressFilterRules(TrafficMirrorFilterRule ... var1);

        public Builder egressFilterRules(Consumer<TrafficMirrorFilterRule.Builder> ... var1);

        public Builder networkServicesWithStrings(Collection<String> var1);

        public Builder networkServicesWithStrings(String ... var1);

        public Builder networkServices(Collection<TrafficMirrorNetworkService> var1);

        public Builder networkServices(TrafficMirrorNetworkService ... var1);

        public Builder description(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

