/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ConversionTaskState;
import software.amazon.awssdk.services.ec2.model.ImportInstanceTaskDetails;
import software.amazon.awssdk.services.ec2.model.ImportVolumeTaskDetails;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConversionTask
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConversionTask> {
    private static final SdkField<String> CONVERSION_TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConversionTaskId").getter(ConversionTask.getter(ConversionTask::conversionTaskId)).setter(ConversionTask.setter(Builder::conversionTaskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConversionTaskId").unmarshallLocationName("conversionTaskId").build()}).build();
    private static final SdkField<String> EXPIRATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExpirationTime").getter(ConversionTask.getter(ConversionTask::expirationTime)).setter(ConversionTask.setter(Builder::expirationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationTime").unmarshallLocationName("expirationTime").build()}).build();
    private static final SdkField<ImportInstanceTaskDetails> IMPORT_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImportInstance").getter(ConversionTask.getter(ConversionTask::importInstance)).setter(ConversionTask.setter(Builder::importInstance)).constructor(ImportInstanceTaskDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportInstance").unmarshallLocationName("importInstance").build()}).build();
    private static final SdkField<ImportVolumeTaskDetails> IMPORT_VOLUME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImportVolume").getter(ConversionTask.getter(ConversionTask::importVolume)).setter(ConversionTask.setter(Builder::importVolume)).constructor(ImportVolumeTaskDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportVolume").unmarshallLocationName("importVolume").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ConversionTask.getter(ConversionTask::stateAsString)).setter(ConversionTask.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(ConversionTask.getter(ConversionTask::statusMessage)).setter(ConversionTask.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").unmarshallLocationName("statusMessage").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ConversionTask.getter(ConversionTask::tags)).setter(ConversionTask.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONVERSION_TASK_ID_FIELD, EXPIRATION_TIME_FIELD, IMPORT_INSTANCE_FIELD, IMPORT_VOLUME_FIELD, STATE_FIELD, STATUS_MESSAGE_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String conversionTaskId;
    private final String expirationTime;
    private final ImportInstanceTaskDetails importInstance;
    private final ImportVolumeTaskDetails importVolume;
    private final String state;
    private final String statusMessage;
    private final List<Tag> tags;

    private ConversionTask(BuilderImpl builder) {
        this.conversionTaskId = builder.conversionTaskId;
        this.expirationTime = builder.expirationTime;
        this.importInstance = builder.importInstance;
        this.importVolume = builder.importVolume;
        this.state = builder.state;
        this.statusMessage = builder.statusMessage;
        this.tags = builder.tags;
    }

    public String conversionTaskId() {
        return this.conversionTaskId;
    }

    public String expirationTime() {
        return this.expirationTime;
    }

    public ImportInstanceTaskDetails importInstance() {
        return this.importInstance;
    }

    public ImportVolumeTaskDetails importVolume() {
        return this.importVolume;
    }

    public ConversionTaskState state() {
        return ConversionTaskState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.conversionTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.importInstance());
        hashCode = 31 * hashCode + Objects.hashCode(this.importVolume());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConversionTask)) {
            return false;
        }
        ConversionTask other = (ConversionTask)obj;
        return Objects.equals(this.conversionTaskId(), other.conversionTaskId()) && Objects.equals(this.expirationTime(), other.expirationTime()) && Objects.equals(this.importInstance(), other.importInstance()) && Objects.equals(this.importVolume(), other.importVolume()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"ConversionTask").add("ConversionTaskId", (Object)this.conversionTaskId()).add("ExpirationTime", (Object)this.expirationTime()).add("ImportInstance", (Object)this.importInstance()).add("ImportVolume", (Object)this.importVolume()).add("State", (Object)this.stateAsString()).add("StatusMessage", (Object)this.statusMessage()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConversionTaskId": {
                return Optional.ofNullable(clazz.cast(this.conversionTaskId()));
            }
            case "ExpirationTime": {
                return Optional.ofNullable(clazz.cast(this.expirationTime()));
            }
            case "ImportInstance": {
                return Optional.ofNullable(clazz.cast(this.importInstance()));
            }
            case "ImportVolume": {
                return Optional.ofNullable(clazz.cast(this.importVolume()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConversionTask, T> g) {
        return obj -> g.apply((ConversionTask)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String conversionTaskId;
        private String expirationTime;
        private ImportInstanceTaskDetails importInstance;
        private ImportVolumeTaskDetails importVolume;
        private String state;
        private String statusMessage;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConversionTask model) {
            this.conversionTaskId(model.conversionTaskId);
            this.expirationTime(model.expirationTime);
            this.importInstance(model.importInstance);
            this.importVolume(model.importVolume);
            this.state(model.state);
            this.statusMessage(model.statusMessage);
            this.tags(model.tags);
        }

        public final String getConversionTaskId() {
            return this.conversionTaskId;
        }

        @Override
        public final Builder conversionTaskId(String conversionTaskId) {
            this.conversionTaskId = conversionTaskId;
            return this;
        }

        public final void setConversionTaskId(String conversionTaskId) {
            this.conversionTaskId = conversionTaskId;
        }

        public final String getExpirationTime() {
            return this.expirationTime;
        }

        @Override
        public final Builder expirationTime(String expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final void setExpirationTime(String expirationTime) {
            this.expirationTime = expirationTime;
        }

        public final ImportInstanceTaskDetails.Builder getImportInstance() {
            return this.importInstance != null ? this.importInstance.toBuilder() : null;
        }

        @Override
        public final Builder importInstance(ImportInstanceTaskDetails importInstance) {
            this.importInstance = importInstance;
            return this;
        }

        public final void setImportInstance(ImportInstanceTaskDetails.BuilderImpl importInstance) {
            this.importInstance = importInstance != null ? importInstance.build() : null;
        }

        public final ImportVolumeTaskDetails.Builder getImportVolume() {
            return this.importVolume != null ? this.importVolume.toBuilder() : null;
        }

        @Override
        public final Builder importVolume(ImportVolumeTaskDetails importVolume) {
            this.importVolume = importVolume;
            return this;
        }

        public final void setImportVolume(ImportVolumeTaskDetails.BuilderImpl importVolume) {
            this.importVolume = importVolume != null ? importVolume.build() : null;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ConversionTaskState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public ConversionTask build() {
            return new ConversionTask(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConversionTask> {
        public Builder conversionTaskId(String var1);

        public Builder expirationTime(String var1);

        public Builder importInstance(ImportInstanceTaskDetails var1);

        default public Builder importInstance(Consumer<ImportInstanceTaskDetails.Builder> importInstance) {
            return this.importInstance((ImportInstanceTaskDetails)((ImportInstanceTaskDetails.Builder)ImportInstanceTaskDetails.builder().applyMutation(importInstance)).build());
        }

        public Builder importVolume(ImportVolumeTaskDetails var1);

        default public Builder importVolume(Consumer<ImportVolumeTaskDetails.Builder> importVolume) {
            return this.importVolume((ImportVolumeTaskDetails)((ImportVolumeTaskDetails.Builder)ImportVolumeTaskDetails.builder().applyMutation(importVolume)).build());
        }

        public Builder state(String var1);

        public Builder state(ConversionTaskState var1);

        public Builder statusMessage(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

