/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ArchitectureType {
    I386("i386"),
    X86_64("x86_64"),
    ARM64("arm64"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ArchitectureType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ArchitectureType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ArchitectureType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ArchitectureType> knownValues() {
        return Stream.of(ArchitectureType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

