/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.ConnectionNotification;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionNotificationsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointConnectionNotificationsResponse;

public class DescribeVpcEndpointConnectionNotificationsIterable
implements SdkIterable<DescribeVpcEndpointConnectionNotificationsResponse> {
    private final Ec2Client client;
    private final DescribeVpcEndpointConnectionNotificationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeVpcEndpointConnectionNotificationsIterable(Ec2Client client, DescribeVpcEndpointConnectionNotificationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeVpcEndpointConnectionNotificationsResponseFetcher();
    }

    public Iterator<DescribeVpcEndpointConnectionNotificationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ConnectionNotification> connectionNotificationSet() {
        Function<DescribeVpcEndpointConnectionNotificationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.connectionNotificationSet() != null) {
                return response.connectionNotificationSet().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeVpcEndpointConnectionNotificationsResponseFetcher
    implements SyncPageFetcher<DescribeVpcEndpointConnectionNotificationsResponse> {
        private DescribeVpcEndpointConnectionNotificationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVpcEndpointConnectionNotificationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeVpcEndpointConnectionNotificationsResponse nextPage(DescribeVpcEndpointConnectionNotificationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeVpcEndpointConnectionNotificationsIterable.this.client.describeVpcEndpointConnectionNotifications(DescribeVpcEndpointConnectionNotificationsIterable.this.firstRequest);
            }
            return DescribeVpcEndpointConnectionNotificationsIterable.this.client.describeVpcEndpointConnectionNotifications((DescribeVpcEndpointConnectionNotificationsRequest)((Object)DescribeVpcEndpointConnectionNotificationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

