/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.InstanceCount;
import software.amazon.awssdk.services.ec2.model.InstanceCountListCopier;
import software.amazon.awssdk.services.ec2.model.ListingStatus;
import software.amazon.awssdk.services.ec2.model.PriceSchedule;
import software.amazon.awssdk.services.ec2.model.PriceScheduleListCopier;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReservedInstancesListing
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReservedInstancesListing> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(ReservedInstancesListing.getter(ReservedInstancesListing::clientToken)).setter(ReservedInstancesListing.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("clientToken").build()}).build();
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateDate").getter(ReservedInstancesListing.getter(ReservedInstancesListing::createDate)).setter(ReservedInstancesListing.setter(Builder::createDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").unmarshallLocationName("createDate").build()}).build();
    private static final SdkField<List<InstanceCount>> INSTANCE_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceCounts").getter(ReservedInstancesListing.getter(ReservedInstancesListing::instanceCounts)).setter(ReservedInstancesListing.setter(Builder::instanceCounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCounts").unmarshallLocationName("instanceCounts").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceCount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<PriceSchedule>> PRICE_SCHEDULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PriceSchedules").getter(ReservedInstancesListing.getter(ReservedInstancesListing::priceSchedules)).setter(ReservedInstancesListing.setter(Builder::priceSchedules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PriceSchedules").unmarshallLocationName("priceSchedules").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PriceSchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> RESERVED_INSTANCES_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedInstancesId").getter(ReservedInstancesListing.getter(ReservedInstancesListing::reservedInstancesId)).setter(ReservedInstancesListing.setter(Builder::reservedInstancesId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesId").unmarshallLocationName("reservedInstancesId").build()}).build();
    private static final SdkField<String> RESERVED_INSTANCES_LISTING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedInstancesListingId").getter(ReservedInstancesListing.getter(ReservedInstancesListing::reservedInstancesListingId)).setter(ReservedInstancesListing.setter(Builder::reservedInstancesListingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesListingId").unmarshallLocationName("reservedInstancesListingId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ReservedInstancesListing.getter(ReservedInstancesListing::statusAsString)).setter(ReservedInstancesListing.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(ReservedInstancesListing.getter(ReservedInstancesListing::statusMessage)).setter(ReservedInstancesListing.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").unmarshallLocationName("statusMessage").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ReservedInstancesListing.getter(ReservedInstancesListing::tags)).setter(ReservedInstancesListing.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Instant> UPDATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdateDate").getter(ReservedInstancesListing.getter(ReservedInstancesListing::updateDate)).setter(ReservedInstancesListing.setter(Builder::updateDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateDate").unmarshallLocationName("updateDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, CREATE_DATE_FIELD, INSTANCE_COUNTS_FIELD, PRICE_SCHEDULES_FIELD, RESERVED_INSTANCES_ID_FIELD, RESERVED_INSTANCES_LISTING_ID_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, TAGS_FIELD, UPDATE_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String clientToken;
    private final Instant createDate;
    private final List<InstanceCount> instanceCounts;
    private final List<PriceSchedule> priceSchedules;
    private final String reservedInstancesId;
    private final String reservedInstancesListingId;
    private final String status;
    private final String statusMessage;
    private final List<Tag> tags;
    private final Instant updateDate;

    private ReservedInstancesListing(BuilderImpl builder) {
        this.clientToken = builder.clientToken;
        this.createDate = builder.createDate;
        this.instanceCounts = builder.instanceCounts;
        this.priceSchedules = builder.priceSchedules;
        this.reservedInstancesId = builder.reservedInstancesId;
        this.reservedInstancesListingId = builder.reservedInstancesListingId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.tags = builder.tags;
        this.updateDate = builder.updateDate;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public Instant createDate() {
        return this.createDate;
    }

    public boolean hasInstanceCounts() {
        return this.instanceCounts != null && !(this.instanceCounts instanceof SdkAutoConstructList);
    }

    public List<InstanceCount> instanceCounts() {
        return this.instanceCounts;
    }

    public boolean hasPriceSchedules() {
        return this.priceSchedules != null && !(this.priceSchedules instanceof SdkAutoConstructList);
    }

    public List<PriceSchedule> priceSchedules() {
        return this.priceSchedules;
    }

    public String reservedInstancesId() {
        return this.reservedInstancesId;
    }

    public String reservedInstancesListingId() {
        return this.reservedInstancesListingId;
    }

    public ListingStatus status() {
        return ListingStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Instant updateDate() {
        return this.updateDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCounts());
        hashCode = 31 * hashCode + Objects.hashCode(this.priceSchedules());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstancesId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstancesListingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstancesListing)) {
            return false;
        }
        ReservedInstancesListing other = (ReservedInstancesListing)obj;
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.instanceCounts(), other.instanceCounts()) && Objects.equals(this.priceSchedules(), other.priceSchedules()) && Objects.equals(this.reservedInstancesId(), other.reservedInstancesId()) && Objects.equals(this.reservedInstancesListingId(), other.reservedInstancesListingId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.updateDate(), other.updateDate());
    }

    public String toString() {
        return ToString.builder((String)"ReservedInstancesListing").add("ClientToken", (Object)this.clientToken()).add("CreateDate", (Object)this.createDate()).add("InstanceCounts", this.instanceCounts()).add("PriceSchedules", this.priceSchedules()).add("ReservedInstancesId", (Object)this.reservedInstancesId()).add("ReservedInstancesListingId", (Object)this.reservedInstancesListingId()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("Tags", this.tags()).add("UpdateDate", (Object)this.updateDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
            case "InstanceCounts": {
                return Optional.ofNullable(clazz.cast(this.instanceCounts()));
            }
            case "PriceSchedules": {
                return Optional.ofNullable(clazz.cast(this.priceSchedules()));
            }
            case "ReservedInstancesId": {
                return Optional.ofNullable(clazz.cast(this.reservedInstancesId()));
            }
            case "ReservedInstancesListingId": {
                return Optional.ofNullable(clazz.cast(this.reservedInstancesListingId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "UpdateDate": {
                return Optional.ofNullable(clazz.cast(this.updateDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReservedInstancesListing, T> g) {
        return obj -> g.apply((ReservedInstancesListing)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clientToken;
        private Instant createDate;
        private List<InstanceCount> instanceCounts = DefaultSdkAutoConstructList.getInstance();
        private List<PriceSchedule> priceSchedules = DefaultSdkAutoConstructList.getInstance();
        private String reservedInstancesId;
        private String reservedInstancesListingId;
        private String status;
        private String statusMessage;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Instant updateDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstancesListing model) {
            this.clientToken(model.clientToken);
            this.createDate(model.createDate);
            this.instanceCounts(model.instanceCounts);
            this.priceSchedules(model.priceSchedules);
            this.reservedInstancesId(model.reservedInstancesId);
            this.reservedInstancesListingId(model.reservedInstancesListingId);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.tags(model.tags);
            this.updateDate(model.updateDate);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final Collection<InstanceCount.Builder> getInstanceCounts() {
            return this.instanceCounts != null ? (Collection)this.instanceCounts.stream().map(InstanceCount::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceCounts(Collection<InstanceCount> instanceCounts) {
            this.instanceCounts = InstanceCountListCopier.copy(instanceCounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceCounts(InstanceCount ... instanceCounts) {
            this.instanceCounts(Arrays.asList(instanceCounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceCounts(Consumer<InstanceCount.Builder> ... instanceCounts) {
            this.instanceCounts(Stream.of(instanceCounts).map(c -> (InstanceCount)((InstanceCount.Builder)InstanceCount.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceCounts(Collection<InstanceCount.BuilderImpl> instanceCounts) {
            this.instanceCounts = InstanceCountListCopier.copyFromBuilder(instanceCounts);
        }

        public final Collection<PriceSchedule.Builder> getPriceSchedules() {
            return this.priceSchedules != null ? (Collection)this.priceSchedules.stream().map(PriceSchedule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder priceSchedules(Collection<PriceSchedule> priceSchedules) {
            this.priceSchedules = PriceScheduleListCopier.copy(priceSchedules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder priceSchedules(PriceSchedule ... priceSchedules) {
            this.priceSchedules(Arrays.asList(priceSchedules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder priceSchedules(Consumer<PriceSchedule.Builder> ... priceSchedules) {
            this.priceSchedules(Stream.of(priceSchedules).map(c -> (PriceSchedule)((PriceSchedule.Builder)PriceSchedule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPriceSchedules(Collection<PriceSchedule.BuilderImpl> priceSchedules) {
            this.priceSchedules = PriceScheduleListCopier.copyFromBuilder(priceSchedules);
        }

        public final String getReservedInstancesId() {
            return this.reservedInstancesId;
        }

        @Override
        public final Builder reservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
            return this;
        }

        public final void setReservedInstancesId(String reservedInstancesId) {
            this.reservedInstancesId = reservedInstancesId;
        }

        public final String getReservedInstancesListingId() {
            return this.reservedInstancesListingId;
        }

        @Override
        public final Builder reservedInstancesListingId(String reservedInstancesListingId) {
            this.reservedInstancesListingId = reservedInstancesListingId;
            return this;
        }

        public final void setReservedInstancesListingId(String reservedInstancesListingId) {
            this.reservedInstancesListingId = reservedInstancesListingId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ListingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Instant getUpdateDate() {
            return this.updateDate;
        }

        @Override
        public final Builder updateDate(Instant updateDate) {
            this.updateDate = updateDate;
            return this;
        }

        public final void setUpdateDate(Instant updateDate) {
            this.updateDate = updateDate;
        }

        public ReservedInstancesListing build() {
            return new ReservedInstancesListing(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReservedInstancesListing> {
        public Builder clientToken(String var1);

        public Builder createDate(Instant var1);

        public Builder instanceCounts(Collection<InstanceCount> var1);

        public Builder instanceCounts(InstanceCount ... var1);

        public Builder instanceCounts(Consumer<InstanceCount.Builder> ... var1);

        public Builder priceSchedules(Collection<PriceSchedule> var1);

        public Builder priceSchedules(PriceSchedule ... var1);

        public Builder priceSchedules(Consumer<PriceSchedule.Builder> ... var1);

        public Builder reservedInstancesId(String var1);

        public Builder reservedInstancesListingId(String var1);

        public Builder status(String var1);

        public Builder status(ListingStatus var1);

        public Builder statusMessage(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder updateDate(Instant var1);
    }
}

