/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InferenceDeviceInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InferenceDeviceInfo> {
    private static final SdkField<Integer> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Count").getter(InferenceDeviceInfo.getter(InferenceDeviceInfo::count)).setter(InferenceDeviceInfo.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").unmarshallLocationName("count").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(InferenceDeviceInfo.getter(InferenceDeviceInfo::name)).setter(InferenceDeviceInfo.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("name").build()}).build();
    private static final SdkField<String> MANUFACTURER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Manufacturer").getter(InferenceDeviceInfo.getter(InferenceDeviceInfo::manufacturer)).setter(InferenceDeviceInfo.setter(Builder::manufacturer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Manufacturer").unmarshallLocationName("manufacturer").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_FIELD, NAME_FIELD, MANUFACTURER_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer count;
    private final String name;
    private final String manufacturer;

    private InferenceDeviceInfo(BuilderImpl builder) {
        this.count = builder.count;
        this.name = builder.name;
        this.manufacturer = builder.manufacturer;
    }

    public Integer count() {
        return this.count;
    }

    public String name() {
        return this.name;
    }

    public String manufacturer() {
        return this.manufacturer;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.manufacturer());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceDeviceInfo)) {
            return false;
        }
        InferenceDeviceInfo other = (InferenceDeviceInfo)obj;
        return Objects.equals(this.count(), other.count()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.manufacturer(), other.manufacturer());
    }

    public String toString() {
        return ToString.builder((String)"InferenceDeviceInfo").add("Count", (Object)this.count()).add("Name", (Object)this.name()).add("Manufacturer", (Object)this.manufacturer()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Manufacturer": {
                return Optional.ofNullable(clazz.cast(this.manufacturer()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InferenceDeviceInfo, T> g) {
        return obj -> g.apply((InferenceDeviceInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer count;
        private String name;
        private String manufacturer;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceDeviceInfo model) {
            this.count(model.count);
            this.name(model.name);
            this.manufacturer(model.manufacturer);
        }

        public final Integer getCount() {
            return this.count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getManufacturer() {
            return this.manufacturer;
        }

        @Override
        public final Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            return this;
        }

        public final void setManufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
        }

        public InferenceDeviceInfo build() {
            return new InferenceDeviceInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InferenceDeviceInfo> {
        public Builder count(Integer var1);

        public Builder name(String var1);

        public Builder manufacturer(String var1);
    }
}

