/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyVpcEndpointServicePermissionsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyVpcEndpointServicePermissionsRequest> {
    private static final SdkField<String> SERVICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceId").getter(ModifyVpcEndpointServicePermissionsRequest.getter(ModifyVpcEndpointServicePermissionsRequest::serviceId)).setter(ModifyVpcEndpointServicePermissionsRequest.setter(Builder::serviceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceId").unmarshallLocationName("ServiceId").build()}).build();
    private static final SdkField<List<String>> ADD_ALLOWED_PRINCIPALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddAllowedPrincipals").getter(ModifyVpcEndpointServicePermissionsRequest.getter(ModifyVpcEndpointServicePermissionsRequest::addAllowedPrincipals)).setter(ModifyVpcEndpointServicePermissionsRequest.setter(Builder::addAllowedPrincipals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddAllowedPrincipals").unmarshallLocationName("AddAllowedPrincipals").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REMOVE_ALLOWED_PRINCIPALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RemoveAllowedPrincipals").getter(ModifyVpcEndpointServicePermissionsRequest.getter(ModifyVpcEndpointServicePermissionsRequest::removeAllowedPrincipals)).setter(ModifyVpcEndpointServicePermissionsRequest.setter(Builder::removeAllowedPrincipals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveAllowedPrincipals").unmarshallLocationName("RemoveAllowedPrincipals").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ID_FIELD, ADD_ALLOWED_PRINCIPALS_FIELD, REMOVE_ALLOWED_PRINCIPALS_FIELD));
    private final String serviceId;
    private final List<String> addAllowedPrincipals;
    private final List<String> removeAllowedPrincipals;

    private ModifyVpcEndpointServicePermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.serviceId = builder.serviceId;
        this.addAllowedPrincipals = builder.addAllowedPrincipals;
        this.removeAllowedPrincipals = builder.removeAllowedPrincipals;
    }

    public String serviceId() {
        return this.serviceId;
    }

    public boolean hasAddAllowedPrincipals() {
        return this.addAllowedPrincipals != null && !(this.addAllowedPrincipals instanceof SdkAutoConstructList);
    }

    public List<String> addAllowedPrincipals() {
        return this.addAllowedPrincipals;
    }

    public boolean hasRemoveAllowedPrincipals() {
        return this.removeAllowedPrincipals != null && !(this.removeAllowedPrincipals instanceof SdkAutoConstructList);
    }

    public List<String> removeAllowedPrincipals() {
        return this.removeAllowedPrincipals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddAllowedPrincipals() ? this.addAllowedPrincipals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRemoveAllowedPrincipals() ? this.removeAllowedPrincipals() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcEndpointServicePermissionsRequest)) {
            return false;
        }
        ModifyVpcEndpointServicePermissionsRequest other = (ModifyVpcEndpointServicePermissionsRequest)((Object)obj);
        return Objects.equals(this.serviceId(), other.serviceId()) && this.hasAddAllowedPrincipals() == other.hasAddAllowedPrincipals() && Objects.equals(this.addAllowedPrincipals(), other.addAllowedPrincipals()) && this.hasRemoveAllowedPrincipals() == other.hasRemoveAllowedPrincipals() && Objects.equals(this.removeAllowedPrincipals(), other.removeAllowedPrincipals());
    }

    public String toString() {
        return ToString.builder((String)"ModifyVpcEndpointServicePermissionsRequest").add("ServiceId", (Object)this.serviceId()).add("AddAllowedPrincipals", this.hasAddAllowedPrincipals() ? this.addAllowedPrincipals() : null).add("RemoveAllowedPrincipals", this.hasRemoveAllowedPrincipals() ? this.removeAllowedPrincipals() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceId": {
                return Optional.ofNullable(clazz.cast(this.serviceId()));
            }
            case "AddAllowedPrincipals": {
                return Optional.ofNullable(clazz.cast(this.addAllowedPrincipals()));
            }
            case "RemoveAllowedPrincipals": {
                return Optional.ofNullable(clazz.cast(this.removeAllowedPrincipals()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVpcEndpointServicePermissionsRequest, T> g) {
        return obj -> g.apply((ModifyVpcEndpointServicePermissionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String serviceId;
        private List<String> addAllowedPrincipals = DefaultSdkAutoConstructList.getInstance();
        private List<String> removeAllowedPrincipals = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcEndpointServicePermissionsRequest model) {
            super(model);
            this.serviceId(model.serviceId);
            this.addAllowedPrincipals(model.addAllowedPrincipals);
            this.removeAllowedPrincipals(model.removeAllowedPrincipals);
        }

        public final String getServiceId() {
            return this.serviceId;
        }

        @Override
        public final Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public final void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }

        public final Collection<String> getAddAllowedPrincipals() {
            if (this.addAllowedPrincipals instanceof SdkAutoConstructList) {
                return null;
            }
            return this.addAllowedPrincipals;
        }

        @Override
        public final Builder addAllowedPrincipals(Collection<String> addAllowedPrincipals) {
            this.addAllowedPrincipals = ValueStringListCopier.copy(addAllowedPrincipals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addAllowedPrincipals(String ... addAllowedPrincipals) {
            this.addAllowedPrincipals(Arrays.asList(addAllowedPrincipals));
            return this;
        }

        public final void setAddAllowedPrincipals(Collection<String> addAllowedPrincipals) {
            this.addAllowedPrincipals = ValueStringListCopier.copy(addAllowedPrincipals);
        }

        public final Collection<String> getRemoveAllowedPrincipals() {
            if (this.removeAllowedPrincipals instanceof SdkAutoConstructList) {
                return null;
            }
            return this.removeAllowedPrincipals;
        }

        @Override
        public final Builder removeAllowedPrincipals(Collection<String> removeAllowedPrincipals) {
            this.removeAllowedPrincipals = ValueStringListCopier.copy(removeAllowedPrincipals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeAllowedPrincipals(String ... removeAllowedPrincipals) {
            this.removeAllowedPrincipals(Arrays.asList(removeAllowedPrincipals));
            return this;
        }

        public final void setRemoveAllowedPrincipals(Collection<String> removeAllowedPrincipals) {
            this.removeAllowedPrincipals = ValueStringListCopier.copy(removeAllowedPrincipals);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVpcEndpointServicePermissionsRequest build() {
            return new ModifyVpcEndpointServicePermissionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyVpcEndpointServicePermissionsRequest> {
        public Builder serviceId(String var1);

        public Builder addAllowedPrincipals(Collection<String> var1);

        public Builder addAllowedPrincipals(String ... var1);

        public Builder removeAllowedPrincipals(Collection<String> var1);

        public Builder removeAllowedPrincipals(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

