/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.InstanceIdsSetCopier;
import software.amazon.awssdk.services.ec2.model.InstanceLifecycle;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateAndOverridesResponse;
import software.amazon.awssdk.services.ec2.model.PlatformValues;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFleetInstance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateFleetInstance> {
    private static final SdkField<LaunchTemplateAndOverridesResponse> LAUNCH_TEMPLATE_AND_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LaunchTemplateAndOverrides").getter(CreateFleetInstance.getter(CreateFleetInstance::launchTemplateAndOverrides)).setter(CreateFleetInstance.setter(Builder::launchTemplateAndOverrides)).constructor(LaunchTemplateAndOverridesResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateAndOverrides").unmarshallLocationName("launchTemplateAndOverrides").build()}).build();
    private static final SdkField<String> LIFECYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Lifecycle").getter(CreateFleetInstance.getter(CreateFleetInstance::lifecycleAsString)).setter(CreateFleetInstance.setter(Builder::lifecycle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").unmarshallLocationName("lifecycle").build()}).build();
    private static final SdkField<List<String>> INSTANCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceIds").getter(CreateFleetInstance.getter(CreateFleetInstance::instanceIds)).setter(CreateFleetInstance.setter(Builder::instanceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceIds").unmarshallLocationName("instanceIds").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(CreateFleetInstance.getter(CreateFleetInstance::instanceTypeAsString)).setter(CreateFleetInstance.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("instanceType").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Platform").getter(CreateFleetInstance.getter(CreateFleetInstance::platformAsString)).setter(CreateFleetInstance.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").unmarshallLocationName("platform").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_TEMPLATE_AND_OVERRIDES_FIELD, LIFECYCLE_FIELD, INSTANCE_IDS_FIELD, INSTANCE_TYPE_FIELD, PLATFORM_FIELD));
    private static final long serialVersionUID = 1L;
    private final LaunchTemplateAndOverridesResponse launchTemplateAndOverrides;
    private final String lifecycle;
    private final List<String> instanceIds;
    private final String instanceType;
    private final String platform;

    private CreateFleetInstance(BuilderImpl builder) {
        this.launchTemplateAndOverrides = builder.launchTemplateAndOverrides;
        this.lifecycle = builder.lifecycle;
        this.instanceIds = builder.instanceIds;
        this.instanceType = builder.instanceType;
        this.platform = builder.platform;
    }

    public LaunchTemplateAndOverridesResponse launchTemplateAndOverrides() {
        return this.launchTemplateAndOverrides;
    }

    public InstanceLifecycle lifecycle() {
        return InstanceLifecycle.fromValue(this.lifecycle);
    }

    public String lifecycleAsString() {
        return this.lifecycle;
    }

    public boolean hasInstanceIds() {
        return this.instanceIds != null && !(this.instanceIds instanceof SdkAutoConstructList);
    }

    public List<String> instanceIds() {
        return this.instanceIds;
    }

    public InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public String instanceTypeAsString() {
        return this.instanceType;
    }

    public PlatformValues platform() {
        return PlatformValues.fromValue(this.platform);
    }

    public String platformAsString() {
        return this.platform;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateAndOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceIds() ? this.instanceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFleetInstance)) {
            return false;
        }
        CreateFleetInstance other = (CreateFleetInstance)obj;
        return Objects.equals(this.launchTemplateAndOverrides(), other.launchTemplateAndOverrides()) && Objects.equals(this.lifecycleAsString(), other.lifecycleAsString()) && this.hasInstanceIds() == other.hasInstanceIds() && Objects.equals(this.instanceIds(), other.instanceIds()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.platformAsString(), other.platformAsString());
    }

    public String toString() {
        return ToString.builder((String)"CreateFleetInstance").add("LaunchTemplateAndOverrides", (Object)this.launchTemplateAndOverrides()).add("Lifecycle", (Object)this.lifecycleAsString()).add("InstanceIds", this.hasInstanceIds() ? this.instanceIds() : null).add("InstanceType", (Object)this.instanceTypeAsString()).add("Platform", (Object)this.platformAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LaunchTemplateAndOverrides": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateAndOverrides()));
            }
            case "Lifecycle": {
                return Optional.ofNullable(clazz.cast(this.lifecycleAsString()));
            }
            case "InstanceIds": {
                return Optional.ofNullable(clazz.cast(this.instanceIds()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "Platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFleetInstance, T> g) {
        return obj -> g.apply((CreateFleetInstance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private LaunchTemplateAndOverridesResponse launchTemplateAndOverrides;
        private String lifecycle;
        private List<String> instanceIds = DefaultSdkAutoConstructList.getInstance();
        private String instanceType;
        private String platform;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFleetInstance model) {
            this.launchTemplateAndOverrides(model.launchTemplateAndOverrides);
            this.lifecycle(model.lifecycle);
            this.instanceIds(model.instanceIds);
            this.instanceType(model.instanceType);
            this.platform(model.platform);
        }

        public final LaunchTemplateAndOverridesResponse.Builder getLaunchTemplateAndOverrides() {
            return this.launchTemplateAndOverrides != null ? this.launchTemplateAndOverrides.toBuilder() : null;
        }

        @Override
        public final Builder launchTemplateAndOverrides(LaunchTemplateAndOverridesResponse launchTemplateAndOverrides) {
            this.launchTemplateAndOverrides = launchTemplateAndOverrides;
            return this;
        }

        public final void setLaunchTemplateAndOverrides(LaunchTemplateAndOverridesResponse.BuilderImpl launchTemplateAndOverrides) {
            this.launchTemplateAndOverrides = launchTemplateAndOverrides != null ? launchTemplateAndOverrides.build() : null;
        }

        public final String getLifecycle() {
            return this.lifecycle;
        }

        @Override
        public final Builder lifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        public final Builder lifecycle(InstanceLifecycle lifecycle) {
            this.lifecycle(lifecycle == null ? null : lifecycle.toString());
            return this;
        }

        public final void setLifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
        }

        public final Collection<String> getInstanceIds() {
            if (this.instanceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceIds;
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdsSetCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String ... instanceIds) {
            this.instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdsSetCopier.copy(instanceIds);
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformValues platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public CreateFleetInstance build() {
            return new CreateFleetInstance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateFleetInstance> {
        public Builder launchTemplateAndOverrides(LaunchTemplateAndOverridesResponse var1);

        default public Builder launchTemplateAndOverrides(Consumer<LaunchTemplateAndOverridesResponse.Builder> launchTemplateAndOverrides) {
            return this.launchTemplateAndOverrides((LaunchTemplateAndOverridesResponse)((LaunchTemplateAndOverridesResponse.Builder)LaunchTemplateAndOverridesResponse.builder().applyMutation(launchTemplateAndOverrides)).build());
        }

        public Builder lifecycle(String var1);

        public Builder lifecycle(InstanceLifecycle var1);

        public Builder instanceIds(Collection<String> var1);

        public Builder instanceIds(String ... var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder platform(String var1);

        public Builder platform(PlatformValues var1);
    }
}

