/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.InstanceIpv6Address;
import software.amazon.awssdk.services.ec2.model.InstanceIpv6AddressListCopier;
import software.amazon.awssdk.services.ec2.model.PrivateIpAddressSpecification;
import software.amazon.awssdk.services.ec2.model.PrivateIpAddressSpecificationListCopier;
import software.amazon.awssdk.services.ec2.model.SecurityGroupIdStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceNetworkInterfaceSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceNetworkInterfaceSpecification> {
    private static final SdkField<Boolean> ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AssociatePublicIpAddress").getter(InstanceNetworkInterfaceSpecification.getter(InstanceNetworkInterfaceSpecification::associatePublicIpAddress)).setter(InstanceNetworkInterfaceSpecification.setter(Builder::associatePublicIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatePublicIpAddress").unmarshallLocationName("associatePublicIpAddress").build()}).build();
    private static final SdkField<Boolean> DELETE_ON_TERMINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeleteOnTermination").getter(InstanceNetworkInterfaceSpecification.getter(InstanceNetworkInterfaceSpecification::deleteOnTermination)).setter(InstanceNetworkInterfaceSpecification.setter(Builder::deleteOnTermination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteOnTermination").unmarshallLocationName("deleteOnTermination").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(InstanceNetworkInterfaceSpecification.getter(InstanceNetworkInterfaceSpecification::description)).setter(InstanceNetworkInterfaceSpecification.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<Integer> DEVICE_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DeviceIndex").getter(InstanceNetworkInterfaceSpecification.getter(InstanceNetworkInterfaceSpecification::deviceIndex)).setter(InstanceNetworkInterfaceSpecification.setter(Builder::deviceIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceIndex").unmarshallLocationName("deviceIndex").build()}).build();
    private static final SdkField<List<String>> GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Groups").getter(InstanceNetworkInterfaceSpecification.getter(InstanceNetworkInterfaceSpecification::groups)).setter(InstanceNetworkInterfaceSpecification.setter(Builder::groups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").unmarshallLocationName("SecurityGroupId").build(), ListTrait.builder().memberLocationName("SecurityGroupId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").unmarshallLocationName("SecurityGroupId").build()}).build()).build()}).build();
    private static final SdkField<Integer> IPV6_ADDRESS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Ipv6AddressCount").getter(InstanceNetworkInterfaceSpecification.getter(InstanceNetworkInterfaceSpecification::ipv6AddressCount)).setter(InstanceNetworkInterfaceSpecification.setter(Builder::ipv6AddressCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6AddressCount").unmarshallLocationName("ipv6AddressCount").build()}).build();
    private static final SdkField<List<InstanceIpv6Address>> IPV6_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ipv6Addresses").getter(InstanceNetworkInterfaceSpecification.getter(InstanceNetworkInterfaceSpecification::ipv6Addresses)).setter(InstanceNetworkInterfaceSpecification.setter(Builder::ipv6Addresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Addresses").unmarshallLocationName("ipv6AddressesSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceIpv6Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceId").getter(InstanceNetworkInterfaceSpecification.getter(InstanceNetworkInterfaceSpecification::networkInterfaceId)).setter(InstanceNetworkInterfaceSpecification.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("networkInterfaceId").build()}).build();
    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateIpAddress").getter(InstanceNetworkInterfaceSpecification.getter(InstanceNetworkInterfaceSpecification::privateIpAddress)).setter(InstanceNetworkInterfaceSpecification.setter(Builder::privateIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress").unmarshallLocationName("privateIpAddress").build()}).build();
    private static final SdkField<List<PrivateIpAddressSpecification>> PRIVATE_IP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrivateIpAddresses").getter(InstanceNetworkInterfaceSpecification.getter(InstanceNetworkInterfaceSpecification::privateIpAddresses)).setter(InstanceNetworkInterfaceSpecification.setter(Builder::privateIpAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddresses").unmarshallLocationName("privateIpAddressesSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PrivateIpAddressSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Integer> SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SecondaryPrivateIpAddressCount").getter(InstanceNetworkInterfaceSpecification.getter(InstanceNetworkInterfaceSpecification::secondaryPrivateIpAddressCount)).setter(InstanceNetworkInterfaceSpecification.setter(Builder::secondaryPrivateIpAddressCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryPrivateIpAddressCount").unmarshallLocationName("secondaryPrivateIpAddressCount").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(InstanceNetworkInterfaceSpecification.getter(InstanceNetworkInterfaceSpecification::subnetId)).setter(InstanceNetworkInterfaceSpecification.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("subnetId").build()}).build();
    private static final SdkField<Boolean> ASSOCIATE_CARRIER_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AssociateCarrierIpAddress").getter(InstanceNetworkInterfaceSpecification.getter(InstanceNetworkInterfaceSpecification::associateCarrierIpAddress)).setter(InstanceNetworkInterfaceSpecification.setter(Builder::associateCarrierIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociateCarrierIpAddress").unmarshallLocationName("AssociateCarrierIpAddress").build()}).build();
    private static final SdkField<String> INTERFACE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InterfaceType").getter(InstanceNetworkInterfaceSpecification.getter(InstanceNetworkInterfaceSpecification::interfaceType)).setter(InstanceNetworkInterfaceSpecification.setter(Builder::interfaceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterfaceType").unmarshallLocationName("InterfaceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD, DELETE_ON_TERMINATION_FIELD, DESCRIPTION_FIELD, DEVICE_INDEX_FIELD, GROUPS_FIELD, IPV6_ADDRESS_COUNT_FIELD, IPV6_ADDRESSES_FIELD, NETWORK_INTERFACE_ID_FIELD, PRIVATE_IP_ADDRESS_FIELD, PRIVATE_IP_ADDRESSES_FIELD, SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD, SUBNET_ID_FIELD, ASSOCIATE_CARRIER_IP_ADDRESS_FIELD, INTERFACE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean associatePublicIpAddress;
    private final Boolean deleteOnTermination;
    private final String description;
    private final Integer deviceIndex;
    private final List<String> groups;
    private final Integer ipv6AddressCount;
    private final List<InstanceIpv6Address> ipv6Addresses;
    private final String networkInterfaceId;
    private final String privateIpAddress;
    private final List<PrivateIpAddressSpecification> privateIpAddresses;
    private final Integer secondaryPrivateIpAddressCount;
    private final String subnetId;
    private final Boolean associateCarrierIpAddress;
    private final String interfaceType;

    private InstanceNetworkInterfaceSpecification(BuilderImpl builder) {
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
        this.deleteOnTermination = builder.deleteOnTermination;
        this.description = builder.description;
        this.deviceIndex = builder.deviceIndex;
        this.groups = builder.groups;
        this.ipv6AddressCount = builder.ipv6AddressCount;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.privateIpAddress = builder.privateIpAddress;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.secondaryPrivateIpAddressCount = builder.secondaryPrivateIpAddressCount;
        this.subnetId = builder.subnetId;
        this.associateCarrierIpAddress = builder.associateCarrierIpAddress;
        this.interfaceType = builder.interfaceType;
    }

    public Boolean associatePublicIpAddress() {
        return this.associatePublicIpAddress;
    }

    public Boolean deleteOnTermination() {
        return this.deleteOnTermination;
    }

    public String description() {
        return this.description;
    }

    public Integer deviceIndex() {
        return this.deviceIndex;
    }

    public boolean hasGroups() {
        return this.groups != null && !(this.groups instanceof SdkAutoConstructList);
    }

    public List<String> groups() {
        return this.groups;
    }

    public Integer ipv6AddressCount() {
        return this.ipv6AddressCount;
    }

    public boolean hasIpv6Addresses() {
        return this.ipv6Addresses != null && !(this.ipv6Addresses instanceof SdkAutoConstructList);
    }

    public List<InstanceIpv6Address> ipv6Addresses() {
        return this.ipv6Addresses;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    public boolean hasPrivateIpAddresses() {
        return this.privateIpAddresses != null && !(this.privateIpAddresses instanceof SdkAutoConstructList);
    }

    public List<PrivateIpAddressSpecification> privateIpAddresses() {
        return this.privateIpAddresses;
    }

    public Integer secondaryPrivateIpAddressCount() {
        return this.secondaryPrivateIpAddressCount;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public Boolean associateCarrierIpAddress() {
        return this.associateCarrierIpAddress;
    }

    public String interfaceType() {
        return this.interfaceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associatePublicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteOnTermination());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.groups());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6AddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6Addresses());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIpAddresses());
        hashCode = 31 * hashCode + Objects.hashCode(this.secondaryPrivateIpAddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associateCarrierIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.interfaceType());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceNetworkInterfaceSpecification)) {
            return false;
        }
        InstanceNetworkInterfaceSpecification other = (InstanceNetworkInterfaceSpecification)obj;
        return Objects.equals(this.associatePublicIpAddress(), other.associatePublicIpAddress()) && Objects.equals(this.deleteOnTermination(), other.deleteOnTermination()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.deviceIndex(), other.deviceIndex()) && Objects.equals(this.groups(), other.groups()) && Objects.equals(this.ipv6AddressCount(), other.ipv6AddressCount()) && Objects.equals(this.ipv6Addresses(), other.ipv6Addresses()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.privateIpAddress(), other.privateIpAddress()) && Objects.equals(this.privateIpAddresses(), other.privateIpAddresses()) && Objects.equals(this.secondaryPrivateIpAddressCount(), other.secondaryPrivateIpAddressCount()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.associateCarrierIpAddress(), other.associateCarrierIpAddress()) && Objects.equals(this.interfaceType(), other.interfaceType());
    }

    public String toString() {
        return ToString.builder((String)"InstanceNetworkInterfaceSpecification").add("AssociatePublicIpAddress", (Object)this.associatePublicIpAddress()).add("DeleteOnTermination", (Object)this.deleteOnTermination()).add("Description", (Object)this.description()).add("DeviceIndex", (Object)this.deviceIndex()).add("Groups", this.groups()).add("Ipv6AddressCount", (Object)this.ipv6AddressCount()).add("Ipv6Addresses", this.ipv6Addresses()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("PrivateIpAddress", (Object)this.privateIpAddress()).add("PrivateIpAddresses", this.privateIpAddresses()).add("SecondaryPrivateIpAddressCount", (Object)this.secondaryPrivateIpAddressCount()).add("SubnetId", (Object)this.subnetId()).add("AssociateCarrierIpAddress", (Object)this.associateCarrierIpAddress()).add("InterfaceType", (Object)this.interfaceType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociatePublicIpAddress": {
                return Optional.ofNullable(clazz.cast(this.associatePublicIpAddress()));
            }
            case "DeleteOnTermination": {
                return Optional.ofNullable(clazz.cast(this.deleteOnTermination()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DeviceIndex": {
                return Optional.ofNullable(clazz.cast(this.deviceIndex()));
            }
            case "Groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
            case "Ipv6AddressCount": {
                return Optional.ofNullable(clazz.cast(this.ipv6AddressCount()));
            }
            case "Ipv6Addresses": {
                return Optional.ofNullable(clazz.cast(this.ipv6Addresses()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "PrivateIpAddress": {
                return Optional.ofNullable(clazz.cast(this.privateIpAddress()));
            }
            case "PrivateIpAddresses": {
                return Optional.ofNullable(clazz.cast(this.privateIpAddresses()));
            }
            case "SecondaryPrivateIpAddressCount": {
                return Optional.ofNullable(clazz.cast(this.secondaryPrivateIpAddressCount()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "AssociateCarrierIpAddress": {
                return Optional.ofNullable(clazz.cast(this.associateCarrierIpAddress()));
            }
            case "InterfaceType": {
                return Optional.ofNullable(clazz.cast(this.interfaceType()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceNetworkInterfaceSpecification, T> g) {
        return obj -> g.apply((InstanceNetworkInterfaceSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean associatePublicIpAddress;
        private Boolean deleteOnTermination;
        private String description;
        private Integer deviceIndex;
        private List<String> groups = DefaultSdkAutoConstructList.getInstance();
        private Integer ipv6AddressCount;
        private List<InstanceIpv6Address> ipv6Addresses = DefaultSdkAutoConstructList.getInstance();
        private String networkInterfaceId;
        private String privateIpAddress;
        private List<PrivateIpAddressSpecification> privateIpAddresses = DefaultSdkAutoConstructList.getInstance();
        private Integer secondaryPrivateIpAddressCount;
        private String subnetId;
        private Boolean associateCarrierIpAddress;
        private String interfaceType;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceNetworkInterfaceSpecification model) {
            this.associatePublicIpAddress(model.associatePublicIpAddress);
            this.deleteOnTermination(model.deleteOnTermination);
            this.description(model.description);
            this.deviceIndex(model.deviceIndex);
            this.groups(model.groups);
            this.ipv6AddressCount(model.ipv6AddressCount);
            this.ipv6Addresses(model.ipv6Addresses);
            this.networkInterfaceId(model.networkInterfaceId);
            this.privateIpAddress(model.privateIpAddress);
            this.privateIpAddresses(model.privateIpAddresses);
            this.secondaryPrivateIpAddressCount(model.secondaryPrivateIpAddressCount);
            this.subnetId(model.subnetId);
            this.associateCarrierIpAddress(model.associateCarrierIpAddress);
            this.interfaceType(model.interfaceType);
        }

        public final Boolean getAssociatePublicIpAddress() {
            return this.associatePublicIpAddress;
        }

        @Override
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        public final Boolean getDeleteOnTermination() {
            return this.deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getDeviceIndex() {
            return this.deviceIndex;
        }

        @Override
        public final Builder deviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
            return this;
        }

        public final void setDeviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
        }

        public final Collection<String> getGroups() {
            return this.groups;
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = SecurityGroupIdStringListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = SecurityGroupIdStringListCopier.copy(groups);
        }

        public final Integer getIpv6AddressCount() {
            return this.ipv6AddressCount;
        }

        @Override
        public final Builder ipv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
            return this;
        }

        public final void setIpv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
        }

        public final Collection<InstanceIpv6Address.Builder> getIpv6Addresses() {
            return this.ipv6Addresses != null ? (Collection)this.ipv6Addresses.stream().map(InstanceIpv6Address::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(InstanceIpv6Address ... ipv6Addresses) {
            this.ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(Consumer<InstanceIpv6Address.Builder> ... ipv6Addresses) {
            this.ipv6Addresses(Stream.of(ipv6Addresses).map(c -> (InstanceIpv6Address)((InstanceIpv6Address.Builder)InstanceIpv6Address.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIpv6Addresses(Collection<InstanceIpv6Address.BuilderImpl> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListCopier.copyFromBuilder(ipv6Addresses);
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public final Collection<PrivateIpAddressSpecification.Builder> getPrivateIpAddresses() {
            return this.privateIpAddresses != null ? (Collection)this.privateIpAddresses.stream().map(PrivateIpAddressSpecification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder privateIpAddresses(Collection<PrivateIpAddressSpecification> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressSpecificationListCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(PrivateIpAddressSpecification ... privateIpAddresses) {
            this.privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(Consumer<PrivateIpAddressSpecification.Builder> ... privateIpAddresses) {
            this.privateIpAddresses(Stream.of(privateIpAddresses).map(c -> (PrivateIpAddressSpecification)((PrivateIpAddressSpecification.Builder)PrivateIpAddressSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPrivateIpAddresses(Collection<PrivateIpAddressSpecification.BuilderImpl> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressSpecificationListCopier.copyFromBuilder(privateIpAddresses);
        }

        public final Integer getSecondaryPrivateIpAddressCount() {
            return this.secondaryPrivateIpAddressCount;
        }

        @Override
        public final Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
            return this;
        }

        public final void setSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final Boolean getAssociateCarrierIpAddress() {
            return this.associateCarrierIpAddress;
        }

        @Override
        public final Builder associateCarrierIpAddress(Boolean associateCarrierIpAddress) {
            this.associateCarrierIpAddress = associateCarrierIpAddress;
            return this;
        }

        public final void setAssociateCarrierIpAddress(Boolean associateCarrierIpAddress) {
            this.associateCarrierIpAddress = associateCarrierIpAddress;
        }

        public final String getInterfaceType() {
            return this.interfaceType;
        }

        @Override
        public final Builder interfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
            return this;
        }

        public final void setInterfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
        }

        public InstanceNetworkInterfaceSpecification build() {
            return new InstanceNetworkInterfaceSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceNetworkInterfaceSpecification> {
        public Builder associatePublicIpAddress(Boolean var1);

        public Builder deleteOnTermination(Boolean var1);

        public Builder description(String var1);

        public Builder deviceIndex(Integer var1);

        public Builder groups(Collection<String> var1);

        public Builder groups(String ... var1);

        public Builder ipv6AddressCount(Integer var1);

        public Builder ipv6Addresses(Collection<InstanceIpv6Address> var1);

        public Builder ipv6Addresses(InstanceIpv6Address ... var1);

        public Builder ipv6Addresses(Consumer<InstanceIpv6Address.Builder> ... var1);

        public Builder networkInterfaceId(String var1);

        public Builder privateIpAddress(String var1);

        public Builder privateIpAddresses(Collection<PrivateIpAddressSpecification> var1);

        public Builder privateIpAddresses(PrivateIpAddressSpecification ... var1);

        public Builder privateIpAddresses(Consumer<PrivateIpAddressSpecification.Builder> ... var1);

        public Builder secondaryPrivateIpAddressCount(Integer var1);

        public Builder subnetId(String var1);

        public Builder associateCarrierIpAddress(Boolean var1);

        public Builder interfaceType(String var1);
    }
}

