/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.InterfacePermissionType;
import software.amazon.awssdk.services.ec2.model.NetworkInterfacePermissionState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkInterfacePermission
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkInterfacePermission> {
    private static final SdkField<String> NETWORK_INTERFACE_PERMISSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NetworkInterfacePermission.getter(NetworkInterfacePermission::networkInterfacePermissionId)).setter(NetworkInterfacePermission.setter(Builder::networkInterfacePermissionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfacePermissionId").unmarshallLocationName("networkInterfacePermissionId").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NetworkInterfacePermission.getter(NetworkInterfacePermission::networkInterfaceId)).setter(NetworkInterfacePermission.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("networkInterfaceId").build()}).build();
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NetworkInterfacePermission.getter(NetworkInterfacePermission::awsAccountId)).setter(NetworkInterfacePermission.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId").unmarshallLocationName("awsAccountId").build()}).build();
    private static final SdkField<String> AWS_SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NetworkInterfacePermission.getter(NetworkInterfacePermission::awsService)).setter(NetworkInterfacePermission.setter(Builder::awsService)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsService").unmarshallLocationName("awsService").build()}).build();
    private static final SdkField<String> PERMISSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NetworkInterfacePermission.getter(NetworkInterfacePermission::permissionAsString)).setter(NetworkInterfacePermission.setter(Builder::permission)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permission").unmarshallLocationName("permission").build()}).build();
    private static final SdkField<NetworkInterfacePermissionState> PERMISSION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(NetworkInterfacePermission.getter(NetworkInterfacePermission::permissionState)).setter(NetworkInterfacePermission.setter(Builder::permissionState)).constructor(NetworkInterfacePermissionState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionState").unmarshallLocationName("permissionState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INTERFACE_PERMISSION_ID_FIELD, NETWORK_INTERFACE_ID_FIELD, AWS_ACCOUNT_ID_FIELD, AWS_SERVICE_FIELD, PERMISSION_FIELD, PERMISSION_STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String networkInterfacePermissionId;
    private final String networkInterfaceId;
    private final String awsAccountId;
    private final String awsService;
    private final String permission;
    private final NetworkInterfacePermissionState permissionState;

    private NetworkInterfacePermission(BuilderImpl builder) {
        this.networkInterfacePermissionId = builder.networkInterfacePermissionId;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.awsAccountId = builder.awsAccountId;
        this.awsService = builder.awsService;
        this.permission = builder.permission;
        this.permissionState = builder.permissionState;
    }

    public String networkInterfacePermissionId() {
        return this.networkInterfacePermissionId;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public String awsAccountId() {
        return this.awsAccountId;
    }

    public String awsService() {
        return this.awsService;
    }

    public InterfacePermissionType permission() {
        return InterfacePermissionType.fromValue(this.permission);
    }

    public String permissionAsString() {
        return this.permission;
    }

    public NetworkInterfacePermissionState permissionState() {
        return this.permissionState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfacePermissionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsService());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionState());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterfacePermission)) {
            return false;
        }
        NetworkInterfacePermission other = (NetworkInterfacePermission)obj;
        return Objects.equals(this.networkInterfacePermissionId(), other.networkInterfacePermissionId()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.awsService(), other.awsService()) && Objects.equals(this.permissionAsString(), other.permissionAsString()) && Objects.equals(this.permissionState(), other.permissionState());
    }

    public String toString() {
        return ToString.builder((String)"NetworkInterfacePermission").add("NetworkInterfacePermissionId", (Object)this.networkInterfacePermissionId()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("AwsAccountId", (Object)this.awsAccountId()).add("AwsService", (Object)this.awsService()).add("Permission", (Object)this.permissionAsString()).add("PermissionState", (Object)this.permissionState()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkInterfacePermissionId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfacePermissionId()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "AwsService": {
                return Optional.ofNullable(clazz.cast(this.awsService()));
            }
            case "Permission": {
                return Optional.ofNullable(clazz.cast(this.permissionAsString()));
            }
            case "PermissionState": {
                return Optional.ofNullable(clazz.cast(this.permissionState()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkInterfacePermission, T> g) {
        return obj -> g.apply((NetworkInterfacePermission)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String networkInterfacePermissionId;
        private String networkInterfaceId;
        private String awsAccountId;
        private String awsService;
        private String permission;
        private NetworkInterfacePermissionState permissionState;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterfacePermission model) {
            this.networkInterfacePermissionId(model.networkInterfacePermissionId);
            this.networkInterfaceId(model.networkInterfaceId);
            this.awsAccountId(model.awsAccountId);
            this.awsService(model.awsService);
            this.permission(model.permission);
            this.permissionState(model.permissionState);
        }

        public final String getNetworkInterfacePermissionId() {
            return this.networkInterfacePermissionId;
        }

        @Override
        public final Builder networkInterfacePermissionId(String networkInterfacePermissionId) {
            this.networkInterfacePermissionId = networkInterfacePermissionId;
            return this;
        }

        public final void setNetworkInterfacePermissionId(String networkInterfacePermissionId) {
            this.networkInterfacePermissionId = networkInterfacePermissionId;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getAwsService() {
            return this.awsService;
        }

        @Override
        public final Builder awsService(String awsService) {
            this.awsService = awsService;
            return this;
        }

        public final void setAwsService(String awsService) {
            this.awsService = awsService;
        }

        public final String getPermission() {
            return this.permission;
        }

        @Override
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        public final Builder permission(InterfacePermissionType permission) {
            this.permission(permission == null ? null : permission.toString());
            return this;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        public final NetworkInterfacePermissionState.Builder getPermissionState() {
            return this.permissionState != null ? this.permissionState.toBuilder() : null;
        }

        @Override
        public final Builder permissionState(NetworkInterfacePermissionState permissionState) {
            this.permissionState = permissionState;
            return this;
        }

        public final void setPermissionState(NetworkInterfacePermissionState.BuilderImpl permissionState) {
            this.permissionState = permissionState != null ? permissionState.build() : null;
        }

        public NetworkInterfacePermission build() {
            return new NetworkInterfacePermission(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkInterfacePermission> {
        public Builder networkInterfacePermissionId(String var1);

        public Builder networkInterfaceId(String var1);

        public Builder awsAccountId(String var1);

        public Builder awsService(String var1);

        public Builder permission(String var1);

        public Builder permission(InterfacePermissionType var1);

        public Builder permissionState(NetworkInterfacePermissionState var1);

        default public Builder permissionState(Consumer<NetworkInterfacePermissionState.Builder> permissionState) {
            return this.permissionState((NetworkInterfacePermissionState)((NetworkInterfacePermissionState.Builder)NetworkInterfacePermissionState.builder().applyMutation(permissionState)).build());
        }
    }
}

