/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CoipAddressUsage;
import software.amazon.awssdk.services.ec2.model.CoipAddressUsageSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCoipPoolUsageResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetCoipPoolUsageResponse> {
    private static final SdkField<String> COIP_POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetCoipPoolUsageResponse.getter(GetCoipPoolUsageResponse::coipPoolId)).setter(GetCoipPoolUsageResponse.setter(Builder::coipPoolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoipPoolId").unmarshallLocationName("coipPoolId").build()}).build();
    private static final SdkField<List<CoipAddressUsage>> COIP_ADDRESS_USAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetCoipPoolUsageResponse.getter(GetCoipPoolUsageResponse::coipAddressUsages)).setter(GetCoipPoolUsageResponse.setter(Builder::coipAddressUsages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoipAddressUsageSet").unmarshallLocationName("coipAddressUsageSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CoipAddressUsage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> LOCAL_GATEWAY_ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetCoipPoolUsageResponse.getter(GetCoipPoolUsageResponse::localGatewayRouteTableId)).setter(GetCoipPoolUsageResponse.setter(Builder::localGatewayRouteTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayRouteTableId").unmarshallLocationName("localGatewayRouteTableId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COIP_POOL_ID_FIELD, COIP_ADDRESS_USAGES_FIELD, LOCAL_GATEWAY_ROUTE_TABLE_ID_FIELD));
    private final String coipPoolId;
    private final List<CoipAddressUsage> coipAddressUsages;
    private final String localGatewayRouteTableId;

    private GetCoipPoolUsageResponse(BuilderImpl builder) {
        super(builder);
        this.coipPoolId = builder.coipPoolId;
        this.coipAddressUsages = builder.coipAddressUsages;
        this.localGatewayRouteTableId = builder.localGatewayRouteTableId;
    }

    public String coipPoolId() {
        return this.coipPoolId;
    }

    public boolean hasCoipAddressUsages() {
        return this.coipAddressUsages != null && !(this.coipAddressUsages instanceof SdkAutoConstructList);
    }

    public List<CoipAddressUsage> coipAddressUsages() {
        return this.coipAddressUsages;
    }

    public String localGatewayRouteTableId() {
        return this.localGatewayRouteTableId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.coipPoolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.coipAddressUsages());
        hashCode = 31 * hashCode + Objects.hashCode(this.localGatewayRouteTableId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCoipPoolUsageResponse)) {
            return false;
        }
        GetCoipPoolUsageResponse other = (GetCoipPoolUsageResponse)((Object)obj);
        return Objects.equals(this.coipPoolId(), other.coipPoolId()) && Objects.equals(this.coipAddressUsages(), other.coipAddressUsages()) && Objects.equals(this.localGatewayRouteTableId(), other.localGatewayRouteTableId());
    }

    public String toString() {
        return ToString.builder((String)"GetCoipPoolUsageResponse").add("CoipPoolId", (Object)this.coipPoolId()).add("CoipAddressUsages", this.coipAddressUsages()).add("LocalGatewayRouteTableId", (Object)this.localGatewayRouteTableId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CoipPoolId": {
                return Optional.ofNullable(clazz.cast(this.coipPoolId()));
            }
            case "CoipAddressUsages": {
                return Optional.ofNullable(clazz.cast(this.coipAddressUsages()));
            }
            case "LocalGatewayRouteTableId": {
                return Optional.ofNullable(clazz.cast(this.localGatewayRouteTableId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCoipPoolUsageResponse, T> g) {
        return obj -> g.apply((GetCoipPoolUsageResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String coipPoolId;
        private List<CoipAddressUsage> coipAddressUsages = DefaultSdkAutoConstructList.getInstance();
        private String localGatewayRouteTableId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCoipPoolUsageResponse model) {
            super(model);
            this.coipPoolId(model.coipPoolId);
            this.coipAddressUsages(model.coipAddressUsages);
            this.localGatewayRouteTableId(model.localGatewayRouteTableId);
        }

        public final String getCoipPoolId() {
            return this.coipPoolId;
        }

        @Override
        public final Builder coipPoolId(String coipPoolId) {
            this.coipPoolId = coipPoolId;
            return this;
        }

        public final void setCoipPoolId(String coipPoolId) {
            this.coipPoolId = coipPoolId;
        }

        public final Collection<CoipAddressUsage.Builder> getCoipAddressUsages() {
            return this.coipAddressUsages != null ? (Collection)this.coipAddressUsages.stream().map(CoipAddressUsage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder coipAddressUsages(Collection<CoipAddressUsage> coipAddressUsages) {
            this.coipAddressUsages = CoipAddressUsageSetCopier.copy(coipAddressUsages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder coipAddressUsages(CoipAddressUsage ... coipAddressUsages) {
            this.coipAddressUsages(Arrays.asList(coipAddressUsages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder coipAddressUsages(Consumer<CoipAddressUsage.Builder> ... coipAddressUsages) {
            this.coipAddressUsages(Stream.of(coipAddressUsages).map(c -> (CoipAddressUsage)((CoipAddressUsage.Builder)CoipAddressUsage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCoipAddressUsages(Collection<CoipAddressUsage.BuilderImpl> coipAddressUsages) {
            this.coipAddressUsages = CoipAddressUsageSetCopier.copyFromBuilder(coipAddressUsages);
        }

        public final String getLocalGatewayRouteTableId() {
            return this.localGatewayRouteTableId;
        }

        @Override
        public final Builder localGatewayRouteTableId(String localGatewayRouteTableId) {
            this.localGatewayRouteTableId = localGatewayRouteTableId;
            return this;
        }

        public final void setLocalGatewayRouteTableId(String localGatewayRouteTableId) {
            this.localGatewayRouteTableId = localGatewayRouteTableId;
        }

        @Override
        public GetCoipPoolUsageResponse build() {
            return new GetCoipPoolUsageResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCoipPoolUsageResponse> {
        public Builder coipPoolId(String var1);

        public Builder coipAddressUsages(Collection<CoipAddressUsage> var1);

        public Builder coipAddressUsages(CoipAddressUsage ... var1);

        public Builder coipAddressUsages(Consumer<CoipAddressUsage.Builder> ... var1);

        public Builder localGatewayRouteTableId(String var1);
    }
}

