/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3Storage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3Storage> {
    private static final SdkField<String> AWS_ACCESS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3Storage.getter(S3Storage::awsAccessKeyId)).setter(S3Storage.setter(Builder::awsAccessKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AWSAccessKeyId").unmarshallLocationName("AWSAccessKeyId").build()}).build();
    private static final SdkField<String> BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3Storage.getter(S3Storage::bucket)).setter(S3Storage.setter(Builder::bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket").unmarshallLocationName("bucket").build()}).build();
    private static final SdkField<String> PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3Storage.getter(S3Storage::prefix)).setter(S3Storage.setter(Builder::prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").unmarshallLocationName("prefix").build()}).build();
    private static final SdkField<SdkBytes> UPLOAD_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).getter(S3Storage.getter(S3Storage::uploadPolicy)).setter(S3Storage.setter(Builder::uploadPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadPolicy").unmarshallLocationName("uploadPolicy").build()}).build();
    private static final SdkField<String> UPLOAD_POLICY_SIGNATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(S3Storage.getter(S3Storage::uploadPolicySignature)).setter(S3Storage.setter(Builder::uploadPolicySignature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadPolicySignature").unmarshallLocationName("uploadPolicySignature").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCESS_KEY_ID_FIELD, BUCKET_FIELD, PREFIX_FIELD, UPLOAD_POLICY_FIELD, UPLOAD_POLICY_SIGNATURE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String awsAccessKeyId;
    private final String bucket;
    private final String prefix;
    private final SdkBytes uploadPolicy;
    private final String uploadPolicySignature;

    private S3Storage(BuilderImpl builder) {
        this.awsAccessKeyId = builder.awsAccessKeyId;
        this.bucket = builder.bucket;
        this.prefix = builder.prefix;
        this.uploadPolicy = builder.uploadPolicy;
        this.uploadPolicySignature = builder.uploadPolicySignature;
    }

    public String awsAccessKeyId() {
        return this.awsAccessKeyId;
    }

    public String bucket() {
        return this.bucket;
    }

    public String prefix() {
        return this.prefix;
    }

    public SdkBytes uploadPolicy() {
        return this.uploadPolicy;
    }

    public String uploadPolicySignature() {
        return this.uploadPolicySignature;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccessKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadPolicySignature());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Storage)) {
            return false;
        }
        S3Storage other = (S3Storage)obj;
        return Objects.equals(this.awsAccessKeyId(), other.awsAccessKeyId()) && Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.uploadPolicy(), other.uploadPolicy()) && Objects.equals(this.uploadPolicySignature(), other.uploadPolicySignature());
    }

    public String toString() {
        return ToString.builder((String)"S3Storage").add("AWSAccessKeyId", (Object)this.awsAccessKeyId()).add("Bucket", (Object)this.bucket()).add("Prefix", (Object)this.prefix()).add("UploadPolicy", (Object)this.uploadPolicy()).add("UploadPolicySignature", (Object)this.uploadPolicySignature()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AWSAccessKeyId": {
                return Optional.ofNullable(clazz.cast(this.awsAccessKeyId()));
            }
            case "Bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "Prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
            case "UploadPolicy": {
                return Optional.ofNullable(clazz.cast(this.uploadPolicy()));
            }
            case "UploadPolicySignature": {
                return Optional.ofNullable(clazz.cast(this.uploadPolicySignature()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3Storage, T> g) {
        return obj -> g.apply((S3Storage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String awsAccessKeyId;
        private String bucket;
        private String prefix;
        private SdkBytes uploadPolicy;
        private String uploadPolicySignature;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Storage model) {
            this.awsAccessKeyId(model.awsAccessKeyId);
            this.bucket(model.bucket);
            this.prefix(model.prefix);
            this.uploadPolicy(model.uploadPolicy);
            this.uploadPolicySignature(model.uploadPolicySignature);
        }

        public final String getAwsAccessKeyId() {
            return this.awsAccessKeyId;
        }

        @Override
        public final Builder awsAccessKeyId(String awsAccessKeyId) {
            this.awsAccessKeyId = awsAccessKeyId;
            return this;
        }

        public final void setAwsAccessKeyId(String awsAccessKeyId) {
            this.awsAccessKeyId = awsAccessKeyId;
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public final ByteBuffer getUploadPolicy() {
            return this.uploadPolicy == null ? null : this.uploadPolicy.asByteBuffer();
        }

        @Override
        public final Builder uploadPolicy(SdkBytes uploadPolicy) {
            this.uploadPolicy = StandardMemberCopier.copy((SdkBytes)uploadPolicy);
            return this;
        }

        public final void setUploadPolicy(ByteBuffer uploadPolicy) {
            this.uploadPolicy(uploadPolicy == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)uploadPolicy));
        }

        public final String getUploadPolicySignature() {
            return this.uploadPolicySignature;
        }

        @Override
        public final Builder uploadPolicySignature(String uploadPolicySignature) {
            this.uploadPolicySignature = uploadPolicySignature;
            return this;
        }

        public final void setUploadPolicySignature(String uploadPolicySignature) {
            this.uploadPolicySignature = uploadPolicySignature;
        }

        public S3Storage build() {
            return new S3Storage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3Storage> {
        public Builder awsAccessKeyId(String var1);

        public Builder bucket(String var1);

        public Builder prefix(String var1);

        public Builder uploadPolicy(SdkBytes var1);

        public Builder uploadPolicySignature(String var1);
    }
}

