/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.TransitGatewayOptions;
import software.amazon.awssdk.services.ec2.model.TransitGatewayState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransitGateway
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransitGateway> {
    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TransitGateway.getter(TransitGateway::transitGatewayId)).setter(TransitGateway.setter(Builder::transitGatewayId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayId").unmarshallLocationName("transitGatewayId").build()}).build();
    private static final SdkField<String> TRANSIT_GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TransitGateway.getter(TransitGateway::transitGatewayArn)).setter(TransitGateway.setter(Builder::transitGatewayArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayArn").unmarshallLocationName("transitGatewayArn").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TransitGateway.getter(TransitGateway::stateAsString)).setter(TransitGateway.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TransitGateway.getter(TransitGateway::ownerId)).setter(TransitGateway.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TransitGateway.getter(TransitGateway::description)).setter(TransitGateway.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(TransitGateway.getter(TransitGateway::creationTime)).setter(TransitGateway.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").unmarshallLocationName("creationTime").build()}).build();
    private static final SdkField<TransitGatewayOptions> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TransitGateway.getter(TransitGateway::options)).setter(TransitGateway.setter(Builder::options)).constructor(TransitGatewayOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").unmarshallLocationName("options").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TransitGateway.getter(TransitGateway::tags)).setter(TransitGateway.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_ID_FIELD, TRANSIT_GATEWAY_ARN_FIELD, STATE_FIELD, OWNER_ID_FIELD, DESCRIPTION_FIELD, CREATION_TIME_FIELD, OPTIONS_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String transitGatewayId;
    private final String transitGatewayArn;
    private final String state;
    private final String ownerId;
    private final String description;
    private final Instant creationTime;
    private final TransitGatewayOptions options;
    private final List<Tag> tags;

    private TransitGateway(BuilderImpl builder) {
        this.transitGatewayId = builder.transitGatewayId;
        this.transitGatewayArn = builder.transitGatewayArn;
        this.state = builder.state;
        this.ownerId = builder.ownerId;
        this.description = builder.description;
        this.creationTime = builder.creationTime;
        this.options = builder.options;
        this.tags = builder.tags;
    }

    public String transitGatewayId() {
        return this.transitGatewayId;
    }

    public String transitGatewayArn() {
        return this.transitGatewayArn;
    }

    public TransitGatewayState state() {
        return TransitGatewayState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public String description() {
        return this.description;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public TransitGatewayOptions options() {
        return this.options;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGateway)) {
            return false;
        }
        TransitGateway other = (TransitGateway)obj;
        return Objects.equals(this.transitGatewayId(), other.transitGatewayId()) && Objects.equals(this.transitGatewayArn(), other.transitGatewayArn()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.options(), other.options()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"TransitGateway").add("TransitGatewayId", (Object)this.transitGatewayId()).add("TransitGatewayArn", (Object)this.transitGatewayArn()).add("State", (Object)this.stateAsString()).add("OwnerId", (Object)this.ownerId()).add("Description", (Object)this.description()).add("CreationTime", (Object)this.creationTime()).add("Options", (Object)this.options()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransitGatewayId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayId()));
            }
            case "TransitGatewayArn": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayArn()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransitGateway, T> g) {
        return obj -> g.apply((TransitGateway)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transitGatewayId;
        private String transitGatewayArn;
        private String state;
        private String ownerId;
        private String description;
        private Instant creationTime;
        private TransitGatewayOptions options;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGateway model) {
            this.transitGatewayId(model.transitGatewayId);
            this.transitGatewayArn(model.transitGatewayArn);
            this.state(model.state);
            this.ownerId(model.ownerId);
            this.description(model.description);
            this.creationTime(model.creationTime);
            this.options(model.options);
            this.tags(model.tags);
        }

        public final String getTransitGatewayId() {
            return this.transitGatewayId;
        }

        @Override
        public final Builder transitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
            return this;
        }

        public final void setTransitGatewayId(String transitGatewayId) {
            this.transitGatewayId = transitGatewayId;
        }

        public final String getTransitGatewayArn() {
            return this.transitGatewayArn;
        }

        @Override
        public final Builder transitGatewayArn(String transitGatewayArn) {
            this.transitGatewayArn = transitGatewayArn;
            return this;
        }

        public final void setTransitGatewayArn(String transitGatewayArn) {
            this.transitGatewayArn = transitGatewayArn;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(TransitGatewayState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final TransitGatewayOptions.Builder getOptions() {
            return this.options != null ? this.options.toBuilder() : null;
        }

        @Override
        public final Builder options(TransitGatewayOptions options) {
            this.options = options;
            return this;
        }

        public final void setOptions(TransitGatewayOptions.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public TransitGateway build() {
            return new TransitGateway(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransitGateway> {
        public Builder transitGatewayId(String var1);

        public Builder transitGatewayArn(String var1);

        public Builder state(String var1);

        public Builder state(TransitGatewayState var1);

        public Builder ownerId(String var1);

        public Builder description(String var1);

        public Builder creationTime(Instant var1);

        public Builder options(TransitGatewayOptions var1);

        default public Builder options(Consumer<TransitGatewayOptions.Builder> options) {
            return this.options((TransitGatewayOptions)((TransitGatewayOptions.Builder)TransitGatewayOptions.builder().applyMutation(options)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

