/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the current state of an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceState implements SdkPojo, Serializable, ToCopyableBuilder<InstanceState.Builder, InstanceState> {
    private static final SdkField<Integer> CODE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(InstanceState::code))
            .setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code")
                    .unmarshallLocationName("code").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(InstanceState::nameAsString))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer code;

    private final String name;

    private InstanceState(BuilderImpl builder) {
        this.code = builder.code;
        this.name = builder.name;
    }

    /**
     * <p>
     * The state of the instance as a 16-bit unsigned integer.
     * </p>
     * <p>
     * The high byte is all of the bits between 2^8 and (2^16)-1, which equals decimal values between 256 and 65,535.
     * These numerical values are used for internal purposes and should be ignored.
     * </p>
     * <p>
     * The low byte is all of the bits between 2^0 and (2^8)-1, which equals decimal values between 0 and 255.
     * </p>
     * <p>
     * The valid values for instance-state-code will all be in the range of the low byte and they are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>0</code> : <code>pending</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>16</code> : <code>running</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>32</code> : <code>shutting-down</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>48</code> : <code>terminated</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>64</code> : <code>stopping</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>80</code> : <code>stopped</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can ignore the high byte value by zeroing out all of the bits above 2^8 or 256 in decimal.
     * </p>
     * 
     * @return The state of the instance as a 16-bit unsigned integer. </p>
     *         <p>
     *         The high byte is all of the bits between 2^8 and (2^16)-1, which equals decimal values between 256 and
     *         65,535. These numerical values are used for internal purposes and should be ignored.
     *         </p>
     *         <p>
     *         The low byte is all of the bits between 2^0 and (2^8)-1, which equals decimal values between 0 and 255.
     *         </p>
     *         <p>
     *         The valid values for instance-state-code will all be in the range of the low byte and they are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>0</code> : <code>pending</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>16</code> : <code>running</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>32</code> : <code>shutting-down</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>48</code> : <code>terminated</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>64</code> : <code>stopping</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>80</code> : <code>stopped</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can ignore the high byte value by zeroing out all of the bits above 2^8 or 256 in decimal.
     */
    public Integer code() {
        return code;
    }

    /**
     * <p>
     * The current state of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link InstanceStateName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The current state of the instance.
     * @see InstanceStateName
     */
    public InstanceStateName name() {
        return InstanceStateName.fromValue(name);
    }

    /**
     * <p>
     * The current state of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link InstanceStateName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The current state of the instance.
     * @see InstanceStateName
     */
    public String nameAsString() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceState)) {
            return false;
        }
        InstanceState other = (InstanceState) obj;
        return Objects.equals(code(), other.code()) && Objects.equals(nameAsString(), other.nameAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InstanceState").add("Code", code()).add("Name", nameAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Code":
            return Optional.ofNullable(clazz.cast(code()));
        case "Name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceState, T> g) {
        return obj -> g.apply((InstanceState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceState> {
        /**
         * <p>
         * The state of the instance as a 16-bit unsigned integer.
         * </p>
         * <p>
         * The high byte is all of the bits between 2^8 and (2^16)-1, which equals decimal values between 256 and
         * 65,535. These numerical values are used for internal purposes and should be ignored.
         * </p>
         * <p>
         * The low byte is all of the bits between 2^0 and (2^8)-1, which equals decimal values between 0 and 255.
         * </p>
         * <p>
         * The valid values for instance-state-code will all be in the range of the low byte and they are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>0</code> : <code>pending</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>16</code> : <code>running</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>32</code> : <code>shutting-down</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>48</code> : <code>terminated</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>64</code> : <code>stopping</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>80</code> : <code>stopped</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can ignore the high byte value by zeroing out all of the bits above 2^8 or 256 in decimal.
         * </p>
         * 
         * @param code
         *        The state of the instance as a 16-bit unsigned integer. </p>
         *        <p>
         *        The high byte is all of the bits between 2^8 and (2^16)-1, which equals decimal values between 256 and
         *        65,535. These numerical values are used for internal purposes and should be ignored.
         *        </p>
         *        <p>
         *        The low byte is all of the bits between 2^0 and (2^8)-1, which equals decimal values between 0 and
         *        255.
         *        </p>
         *        <p>
         *        The valid values for instance-state-code will all be in the range of the low byte and they are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>0</code> : <code>pending</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>16</code> : <code>running</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>32</code> : <code>shutting-down</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>48</code> : <code>terminated</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>64</code> : <code>stopping</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>80</code> : <code>stopped</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can ignore the high byte value by zeroing out all of the bits above 2^8 or 256 in decimal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(Integer code);

        /**
         * <p>
         * The current state of the instance.
         * </p>
         * 
         * @param name
         *        The current state of the instance.
         * @see InstanceStateName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceStateName
         */
        Builder name(String name);

        /**
         * <p>
         * The current state of the instance.
         * </p>
         * 
         * @param name
         *        The current state of the instance.
         * @see InstanceStateName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceStateName
         */
        Builder name(InstanceStateName name);
    }

    static final class BuilderImpl implements Builder {
        private Integer code;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceState model) {
            code(model.code);
            name(model.name);
        }

        public final Integer getCode() {
            return code;
        }

        @Override
        public final Builder code(Integer code) {
            this.code = code;
            return this;
        }

        public final void setCode(Integer code) {
            this.code = code;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(InstanceStateName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public InstanceState build() {
            return new InstanceState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
