/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLaunchTemplateVersionsResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeLaunchTemplateVersionsResponse.Builder, DescribeLaunchTemplateVersionsResponse> {
    private static final SdkField<List<LaunchTemplateVersion>> LAUNCH_TEMPLATE_VERSIONS_FIELD = SdkField
            .<List<LaunchTemplateVersion>> builder(MarshallingType.LIST)
            .getter(getter(DescribeLaunchTemplateVersionsResponse::launchTemplateVersions))
            .setter(setter(Builder::launchTemplateVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateVersionSet")
                    .unmarshallLocationName("launchTemplateVersionSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<LaunchTemplateVersion> builder(MarshallingType.SDK_POJO)
                                            .constructor(LaunchTemplateVersion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeLaunchTemplateVersionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LAUNCH_TEMPLATE_VERSIONS_FIELD, NEXT_TOKEN_FIELD));

    private final List<LaunchTemplateVersion> launchTemplateVersions;

    private final String nextToken;

    private DescribeLaunchTemplateVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.launchTemplateVersions = builder.launchTemplateVersions;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the LaunchTemplateVersions property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasLaunchTemplateVersions() {
        return launchTemplateVersions != null && !(launchTemplateVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the launch template versions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLaunchTemplateVersions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the launch template versions.
     */
    public List<LaunchTemplateVersion> launchTemplateVersions() {
        return launchTemplateVersions;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateVersions());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLaunchTemplateVersionsResponse)) {
            return false;
        }
        DescribeLaunchTemplateVersionsResponse other = (DescribeLaunchTemplateVersionsResponse) obj;
        return Objects.equals(launchTemplateVersions(), other.launchTemplateVersions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeLaunchTemplateVersionsResponse").add("LaunchTemplateVersions", launchTemplateVersions())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LaunchTemplateVersions":
            return Optional.ofNullable(clazz.cast(launchTemplateVersions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLaunchTemplateVersionsResponse, T> g) {
        return obj -> g.apply((DescribeLaunchTemplateVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeLaunchTemplateVersionsResponse> {
        /**
         * <p>
         * Information about the launch template versions.
         * </p>
         * 
         * @param launchTemplateVersions
         *        Information about the launch template versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateVersions(Collection<LaunchTemplateVersion> launchTemplateVersions);

        /**
         * <p>
         * Information about the launch template versions.
         * </p>
         * 
         * @param launchTemplateVersions
         *        Information about the launch template versions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateVersions(LaunchTemplateVersion... launchTemplateVersions);

        /**
         * <p>
         * Information about the launch template versions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LaunchTemplateVersion>.Builder} avoiding
         * the need to create one manually via {@link List<LaunchTemplateVersion>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LaunchTemplateVersion>.Builder#build()} is called
         * immediately and its result is passed to {@link #launchTemplateVersions(List<LaunchTemplateVersion>)}.
         * 
         * @param launchTemplateVersions
         *        a consumer that will call methods on {@link List<LaunchTemplateVersion>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplateVersions(List<LaunchTemplateVersion>)
         */
        Builder launchTemplateVersions(Consumer<LaunchTemplateVersion.Builder>... launchTemplateVersions);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<LaunchTemplateVersion> launchTemplateVersions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLaunchTemplateVersionsResponse model) {
            super(model);
            launchTemplateVersions(model.launchTemplateVersions);
            nextToken(model.nextToken);
        }

        public final Collection<LaunchTemplateVersion.Builder> getLaunchTemplateVersions() {
            return launchTemplateVersions != null ? launchTemplateVersions.stream().map(LaunchTemplateVersion::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder launchTemplateVersions(Collection<LaunchTemplateVersion> launchTemplateVersions) {
            this.launchTemplateVersions = LaunchTemplateVersionSetCopier.copy(launchTemplateVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplateVersions(LaunchTemplateVersion... launchTemplateVersions) {
            launchTemplateVersions(Arrays.asList(launchTemplateVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchTemplateVersions(Consumer<LaunchTemplateVersion.Builder>... launchTemplateVersions) {
            launchTemplateVersions(Stream.of(launchTemplateVersions)
                    .map(c -> LaunchTemplateVersion.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLaunchTemplateVersions(Collection<LaunchTemplateVersion.BuilderImpl> launchTemplateVersions) {
            this.launchTemplateVersions = LaunchTemplateVersionSetCopier.copyFromBuilder(launchTemplateVersions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeLaunchTemplateVersionsResponse build() {
            return new DescribeLaunchTemplateVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
