/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInstanceEventNotificationAttributesResponse extends Ec2Response
        implements
        ToCopyableBuilder<DescribeInstanceEventNotificationAttributesResponse.Builder, DescribeInstanceEventNotificationAttributesResponse> {
    private static final SdkField<InstanceTagNotificationAttribute> INSTANCE_TAG_ATTRIBUTE_FIELD = SdkField
            .<InstanceTagNotificationAttribute> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeInstanceEventNotificationAttributesResponse::instanceTagAttribute))
            .setter(setter(Builder::instanceTagAttribute))
            .constructor(InstanceTagNotificationAttribute::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceTagAttribute")
                    .unmarshallLocationName("instanceTagAttribute").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TAG_ATTRIBUTE_FIELD));

    private final InstanceTagNotificationAttribute instanceTagAttribute;

    private DescribeInstanceEventNotificationAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.instanceTagAttribute = builder.instanceTagAttribute;
    }

    /**
     * <p>
     * Information about the registered tag keys.
     * </p>
     * 
     * @return Information about the registered tag keys.
     */
    public InstanceTagNotificationAttribute instanceTagAttribute() {
        return instanceTagAttribute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceTagAttribute());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceEventNotificationAttributesResponse)) {
            return false;
        }
        DescribeInstanceEventNotificationAttributesResponse other = (DescribeInstanceEventNotificationAttributesResponse) obj;
        return Objects.equals(instanceTagAttribute(), other.instanceTagAttribute());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeInstanceEventNotificationAttributesResponse")
                .add("InstanceTagAttribute", instanceTagAttribute()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceTagAttribute":
            return Optional.ofNullable(clazz.cast(instanceTagAttribute()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstanceEventNotificationAttributesResponse, T> g) {
        return obj -> g.apply((DescribeInstanceEventNotificationAttributesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeInstanceEventNotificationAttributesResponse> {
        /**
         * <p>
         * Information about the registered tag keys.
         * </p>
         * 
         * @param instanceTagAttribute
         *        Information about the registered tag keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTagAttribute(InstanceTagNotificationAttribute instanceTagAttribute);

        /**
         * <p>
         * Information about the registered tag keys.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceTagNotificationAttribute.Builder}
         * avoiding the need to create one manually via {@link InstanceTagNotificationAttribute#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceTagNotificationAttribute.Builder#build()} is called
         * immediately and its result is passed to {@link #instanceTagAttribute(InstanceTagNotificationAttribute)}.
         * 
         * @param instanceTagAttribute
         *        a consumer that will call methods on {@link InstanceTagNotificationAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceTagAttribute(InstanceTagNotificationAttribute)
         */
        default Builder instanceTagAttribute(Consumer<InstanceTagNotificationAttribute.Builder> instanceTagAttribute) {
            return instanceTagAttribute(InstanceTagNotificationAttribute.builder().applyMutation(instanceTagAttribute).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private InstanceTagNotificationAttribute instanceTagAttribute;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceEventNotificationAttributesResponse model) {
            super(model);
            instanceTagAttribute(model.instanceTagAttribute);
        }

        public final InstanceTagNotificationAttribute.Builder getInstanceTagAttribute() {
            return instanceTagAttribute != null ? instanceTagAttribute.toBuilder() : null;
        }

        @Override
        public final Builder instanceTagAttribute(InstanceTagNotificationAttribute instanceTagAttribute) {
            this.instanceTagAttribute = instanceTagAttribute;
            return this;
        }

        public final void setInstanceTagAttribute(InstanceTagNotificationAttribute.BuilderImpl instanceTagAttribute) {
            this.instanceTagAttribute = instanceTagAttribute != null ? instanceTagAttribute.build() : null;
        }

        @Override
        public DescribeInstanceEventNotificationAttributesResponse build() {
            return new DescribeInstanceEventNotificationAttributesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
