/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLaunchTemplateDataResponse extends Ec2Response implements
        ToCopyableBuilder<GetLaunchTemplateDataResponse.Builder, GetLaunchTemplateDataResponse> {
    private static final SdkField<ResponseLaunchTemplateData> LAUNCH_TEMPLATE_DATA_FIELD = SdkField
            .<ResponseLaunchTemplateData> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetLaunchTemplateDataResponse::launchTemplateData))
            .setter(setter(Builder::launchTemplateData))
            .constructor(ResponseLaunchTemplateData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateData")
                    .unmarshallLocationName("launchTemplateData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_TEMPLATE_DATA_FIELD));

    private final ResponseLaunchTemplateData launchTemplateData;

    private GetLaunchTemplateDataResponse(BuilderImpl builder) {
        super(builder);
        this.launchTemplateData = builder.launchTemplateData;
    }

    /**
     * <p>
     * The instance data.
     * </p>
     * 
     * @return The instance data.
     */
    public ResponseLaunchTemplateData launchTemplateData() {
        return launchTemplateData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateData());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLaunchTemplateDataResponse)) {
            return false;
        }
        GetLaunchTemplateDataResponse other = (GetLaunchTemplateDataResponse) obj;
        return Objects.equals(launchTemplateData(), other.launchTemplateData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetLaunchTemplateDataResponse").add("LaunchTemplateData", launchTemplateData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LaunchTemplateData":
            return Optional.ofNullable(clazz.cast(launchTemplateData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLaunchTemplateDataResponse, T> g) {
        return obj -> g.apply((GetLaunchTemplateDataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetLaunchTemplateDataResponse> {
        /**
         * <p>
         * The instance data.
         * </p>
         * 
         * @param launchTemplateData
         *        The instance data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateData(ResponseLaunchTemplateData launchTemplateData);

        /**
         * <p>
         * The instance data.
         * </p>
         * This is a convenience that creates an instance of the {@link ResponseLaunchTemplateData.Builder} avoiding the
         * need to create one manually via {@link ResponseLaunchTemplateData#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResponseLaunchTemplateData.Builder#build()} is called immediately
         * and its result is passed to {@link #launchTemplateData(ResponseLaunchTemplateData)}.
         * 
         * @param launchTemplateData
         *        a consumer that will call methods on {@link ResponseLaunchTemplateData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplateData(ResponseLaunchTemplateData)
         */
        default Builder launchTemplateData(Consumer<ResponseLaunchTemplateData.Builder> launchTemplateData) {
            return launchTemplateData(ResponseLaunchTemplateData.builder().applyMutation(launchTemplateData).build());
        }
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private ResponseLaunchTemplateData launchTemplateData;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLaunchTemplateDataResponse model) {
            super(model);
            launchTemplateData(model.launchTemplateData);
        }

        public final ResponseLaunchTemplateData.Builder getLaunchTemplateData() {
            return launchTemplateData != null ? launchTemplateData.toBuilder() : null;
        }

        @Override
        public final Builder launchTemplateData(ResponseLaunchTemplateData launchTemplateData) {
            this.launchTemplateData = launchTemplateData;
            return this;
        }

        public final void setLaunchTemplateData(ResponseLaunchTemplateData.BuilderImpl launchTemplateData) {
            this.launchTemplateData = launchTemplateData != null ? launchTemplateData.build() : null;
        }

        @Override
        public GetLaunchTemplateDataResponse build() {
            return new GetLaunchTemplateDataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
