/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLocalGatewayRouteTablesResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeLocalGatewayRouteTablesResponse.Builder, DescribeLocalGatewayRouteTablesResponse> {
    private static final SdkField<List<LocalGatewayRouteTable>> LOCAL_GATEWAY_ROUTE_TABLES_FIELD = SdkField
            .<List<LocalGatewayRouteTable>> builder(MarshallingType.LIST)
            .getter(getter(DescribeLocalGatewayRouteTablesResponse::localGatewayRouteTables))
            .setter(setter(Builder::localGatewayRouteTables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalGatewayRouteTableSet")
                    .unmarshallLocationName("localGatewayRouteTableSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<LocalGatewayRouteTable> builder(MarshallingType.SDK_POJO)
                                            .constructor(LocalGatewayRouteTable::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeLocalGatewayRouteTablesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LOCAL_GATEWAY_ROUTE_TABLES_FIELD, NEXT_TOKEN_FIELD));

    private final List<LocalGatewayRouteTable> localGatewayRouteTables;

    private final String nextToken;

    private DescribeLocalGatewayRouteTablesResponse(BuilderImpl builder) {
        super(builder);
        this.localGatewayRouteTables = builder.localGatewayRouteTables;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the LocalGatewayRouteTables property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasLocalGatewayRouteTables() {
        return localGatewayRouteTables != null && !(localGatewayRouteTables instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the local gateway route tables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLocalGatewayRouteTables()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the local gateway route tables.
     */
    public List<LocalGatewayRouteTable> localGatewayRouteTables() {
        return localGatewayRouteTables;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(localGatewayRouteTables());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLocalGatewayRouteTablesResponse)) {
            return false;
        }
        DescribeLocalGatewayRouteTablesResponse other = (DescribeLocalGatewayRouteTablesResponse) obj;
        return Objects.equals(localGatewayRouteTables(), other.localGatewayRouteTables())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeLocalGatewayRouteTablesResponse")
                .add("LocalGatewayRouteTables", localGatewayRouteTables()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LocalGatewayRouteTables":
            return Optional.ofNullable(clazz.cast(localGatewayRouteTables()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLocalGatewayRouteTablesResponse, T> g) {
        return obj -> g.apply((DescribeLocalGatewayRouteTablesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeLocalGatewayRouteTablesResponse> {
        /**
         * <p>
         * Information about the local gateway route tables.
         * </p>
         * 
         * @param localGatewayRouteTables
         *        Information about the local gateway route tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayRouteTables(Collection<LocalGatewayRouteTable> localGatewayRouteTables);

        /**
         * <p>
         * Information about the local gateway route tables.
         * </p>
         * 
         * @param localGatewayRouteTables
         *        Information about the local gateway route tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localGatewayRouteTables(LocalGatewayRouteTable... localGatewayRouteTables);

        /**
         * <p>
         * Information about the local gateway route tables.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LocalGatewayRouteTable>.Builder} avoiding
         * the need to create one manually via {@link List<LocalGatewayRouteTable>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LocalGatewayRouteTable>.Builder#build()} is called
         * immediately and its result is passed to {@link #localGatewayRouteTables(List<LocalGatewayRouteTable>)}.
         * 
         * @param localGatewayRouteTables
         *        a consumer that will call methods on {@link List<LocalGatewayRouteTable>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #localGatewayRouteTables(List<LocalGatewayRouteTable>)
         */
        Builder localGatewayRouteTables(Consumer<LocalGatewayRouteTable.Builder>... localGatewayRouteTables);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<LocalGatewayRouteTable> localGatewayRouteTables = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLocalGatewayRouteTablesResponse model) {
            super(model);
            localGatewayRouteTables(model.localGatewayRouteTables);
            nextToken(model.nextToken);
        }

        public final Collection<LocalGatewayRouteTable.Builder> getLocalGatewayRouteTables() {
            return localGatewayRouteTables != null ? localGatewayRouteTables.stream().map(LocalGatewayRouteTable::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder localGatewayRouteTables(Collection<LocalGatewayRouteTable> localGatewayRouteTables) {
            this.localGatewayRouteTables = LocalGatewayRouteTableSetCopier.copy(localGatewayRouteTables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localGatewayRouteTables(LocalGatewayRouteTable... localGatewayRouteTables) {
            localGatewayRouteTables(Arrays.asList(localGatewayRouteTables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localGatewayRouteTables(Consumer<LocalGatewayRouteTable.Builder>... localGatewayRouteTables) {
            localGatewayRouteTables(Stream.of(localGatewayRouteTables)
                    .map(c -> LocalGatewayRouteTable.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLocalGatewayRouteTables(Collection<LocalGatewayRouteTable.BuilderImpl> localGatewayRouteTables) {
            this.localGatewayRouteTables = LocalGatewayRouteTableSetCopier.copyFromBuilder(localGatewayRouteTables);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeLocalGatewayRouteTablesResponse build() {
            return new DescribeLocalGatewayRouteTablesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
