/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.ClientVpnEndpoint;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnEndpointsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeClientVpnEndpointsResponse;

public class DescribeClientVpnEndpointsIterable
implements SdkIterable<DescribeClientVpnEndpointsResponse> {
    private final Ec2Client client;
    private final DescribeClientVpnEndpointsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeClientVpnEndpointsIterable(Ec2Client client, DescribeClientVpnEndpointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeClientVpnEndpointsResponseFetcher();
    }

    public Iterator<DescribeClientVpnEndpointsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ClientVpnEndpoint> clientVpnEndpoints() {
        Function<DescribeClientVpnEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.clientVpnEndpoints() != null) {
                return response.clientVpnEndpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeClientVpnEndpointsResponseFetcher
    implements SyncPageFetcher<DescribeClientVpnEndpointsResponse> {
        private DescribeClientVpnEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClientVpnEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeClientVpnEndpointsResponse nextPage(DescribeClientVpnEndpointsResponse previousPage) {
            if (previousPage == null) {
                return DescribeClientVpnEndpointsIterable.this.client.describeClientVpnEndpoints(DescribeClientVpnEndpointsIterable.this.firstRequest);
            }
            return DescribeClientVpnEndpointsIterable.this.client.describeClientVpnEndpoints((DescribeClientVpnEndpointsRequest)((Object)DescribeClientVpnEndpointsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

