/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.FlowLogsResourceType;
import software.amazon.awssdk.services.ec2.model.LogDestinationType;
import software.amazon.awssdk.services.ec2.model.TrafficType;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFlowLogsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateFlowLogsRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateFlowLogsRequest.getter(CreateFlowLogsRequest::clientToken)).setter(CreateFlowLogsRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build()}).build();
    private static final SdkField<String> DELIVER_LOGS_PERMISSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateFlowLogsRequest.getter(CreateFlowLogsRequest::deliverLogsPermissionArn)).setter(CreateFlowLogsRequest.setter(Builder::deliverLogsPermissionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliverLogsPermissionArn").unmarshallLocationName("DeliverLogsPermissionArn").build()}).build();
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateFlowLogsRequest.getter(CreateFlowLogsRequest::logGroupName)).setter(CreateFlowLogsRequest.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroupName").unmarshallLocationName("LogGroupName").build()}).build();
    private static final SdkField<List<String>> RESOURCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateFlowLogsRequest.getter(CreateFlowLogsRequest::resourceIds)).setter(CreateFlowLogsRequest.setter(Builder::resourceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").unmarshallLocationName("ResourceId").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateFlowLogsRequest.getter(CreateFlowLogsRequest::resourceTypeAsString)).setter(CreateFlowLogsRequest.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").unmarshallLocationName("ResourceType").build()}).build();
    private static final SdkField<String> TRAFFIC_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateFlowLogsRequest.getter(CreateFlowLogsRequest::trafficTypeAsString)).setter(CreateFlowLogsRequest.setter(Builder::trafficType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficType").unmarshallLocationName("TrafficType").build()}).build();
    private static final SdkField<String> LOG_DESTINATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateFlowLogsRequest.getter(CreateFlowLogsRequest::logDestinationTypeAsString)).setter(CreateFlowLogsRequest.setter(Builder::logDestinationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDestinationType").unmarshallLocationName("LogDestinationType").build()}).build();
    private static final SdkField<String> LOG_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateFlowLogsRequest.getter(CreateFlowLogsRequest::logDestination)).setter(CreateFlowLogsRequest.setter(Builder::logDestination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDestination").unmarshallLocationName("LogDestination").build()}).build();
    private static final SdkField<String> LOG_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateFlowLogsRequest.getter(CreateFlowLogsRequest::logFormat)).setter(CreateFlowLogsRequest.setter(Builder::logFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogFormat").unmarshallLocationName("LogFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DELIVER_LOGS_PERMISSION_ARN_FIELD, LOG_GROUP_NAME_FIELD, RESOURCE_IDS_FIELD, RESOURCE_TYPE_FIELD, TRAFFIC_TYPE_FIELD, LOG_DESTINATION_TYPE_FIELD, LOG_DESTINATION_FIELD, LOG_FORMAT_FIELD));
    private final String clientToken;
    private final String deliverLogsPermissionArn;
    private final String logGroupName;
    private final List<String> resourceIds;
    private final String resourceType;
    private final String trafficType;
    private final String logDestinationType;
    private final String logDestination;
    private final String logFormat;

    private CreateFlowLogsRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.deliverLogsPermissionArn = builder.deliverLogsPermissionArn;
        this.logGroupName = builder.logGroupName;
        this.resourceIds = builder.resourceIds;
        this.resourceType = builder.resourceType;
        this.trafficType = builder.trafficType;
        this.logDestinationType = builder.logDestinationType;
        this.logDestination = builder.logDestination;
        this.logFormat = builder.logFormat;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public String deliverLogsPermissionArn() {
        return this.deliverLogsPermissionArn;
    }

    public String logGroupName() {
        return this.logGroupName;
    }

    public boolean hasResourceIds() {
        return this.resourceIds != null && !(this.resourceIds instanceof SdkAutoConstructList);
    }

    public List<String> resourceIds() {
        return this.resourceIds;
    }

    public FlowLogsResourceType resourceType() {
        return FlowLogsResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeAsString() {
        return this.resourceType;
    }

    public TrafficType trafficType() {
        return TrafficType.fromValue(this.trafficType);
    }

    public String trafficTypeAsString() {
        return this.trafficType;
    }

    public LogDestinationType logDestinationType() {
        return LogDestinationType.fromValue(this.logDestinationType);
    }

    public String logDestinationTypeAsString() {
        return this.logDestinationType;
    }

    public String logDestination() {
        return this.logDestination;
    }

    public String logFormat() {
        return this.logFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliverLogsPermissionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logDestinationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logDestination());
        hashCode = 31 * hashCode + Objects.hashCode(this.logFormat());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFlowLogsRequest)) {
            return false;
        }
        CreateFlowLogsRequest other = (CreateFlowLogsRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.deliverLogsPermissionArn(), other.deliverLogsPermissionArn()) && Objects.equals(this.logGroupName(), other.logGroupName()) && Objects.equals(this.resourceIds(), other.resourceIds()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.trafficTypeAsString(), other.trafficTypeAsString()) && Objects.equals(this.logDestinationTypeAsString(), other.logDestinationTypeAsString()) && Objects.equals(this.logDestination(), other.logDestination()) && Objects.equals(this.logFormat(), other.logFormat());
    }

    public String toString() {
        return ToString.builder((String)"CreateFlowLogsRequest").add("ClientToken", (Object)this.clientToken()).add("DeliverLogsPermissionArn", (Object)this.deliverLogsPermissionArn()).add("LogGroupName", (Object)this.logGroupName()).add("ResourceIds", this.resourceIds()).add("ResourceType", (Object)this.resourceTypeAsString()).add("TrafficType", (Object)this.trafficTypeAsString()).add("LogDestinationType", (Object)this.logDestinationTypeAsString()).add("LogDestination", (Object)this.logDestination()).add("LogFormat", (Object)this.logFormat()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "DeliverLogsPermissionArn": {
                return Optional.ofNullable(clazz.cast(this.deliverLogsPermissionArn()));
            }
            case "LogGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
            case "ResourceIds": {
                return Optional.ofNullable(clazz.cast(this.resourceIds()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "TrafficType": {
                return Optional.ofNullable(clazz.cast(this.trafficTypeAsString()));
            }
            case "LogDestinationType": {
                return Optional.ofNullable(clazz.cast(this.logDestinationTypeAsString()));
            }
            case "LogDestination": {
                return Optional.ofNullable(clazz.cast(this.logDestination()));
            }
            case "LogFormat": {
                return Optional.ofNullable(clazz.cast(this.logFormat()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFlowLogsRequest, T> g) {
        return obj -> g.apply((CreateFlowLogsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String clientToken;
        private String deliverLogsPermissionArn;
        private String logGroupName;
        private List<String> resourceIds = DefaultSdkAutoConstructList.getInstance();
        private String resourceType;
        private String trafficType;
        private String logDestinationType;
        private String logDestination;
        private String logFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFlowLogsRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.deliverLogsPermissionArn(model.deliverLogsPermissionArn);
            this.logGroupName(model.logGroupName);
            this.resourceIds(model.resourceIds);
            this.resourceType(model.resourceType);
            this.trafficType(model.trafficType);
            this.logDestinationType(model.logDestinationType);
            this.logDestination(model.logDestination);
            this.logFormat(model.logFormat);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getDeliverLogsPermissionArn() {
            return this.deliverLogsPermissionArn;
        }

        @Override
        public final Builder deliverLogsPermissionArn(String deliverLogsPermissionArn) {
            this.deliverLogsPermissionArn = deliverLogsPermissionArn;
            return this;
        }

        public final void setDeliverLogsPermissionArn(String deliverLogsPermissionArn) {
            this.deliverLogsPermissionArn = deliverLogsPermissionArn;
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final Collection<String> getResourceIds() {
            return this.resourceIds;
        }

        @Override
        public final Builder resourceIds(Collection<String> resourceIds) {
            this.resourceIds = ValueStringListCopier.copy(resourceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceIds(String ... resourceIds) {
            this.resourceIds(Arrays.asList(resourceIds));
            return this;
        }

        public final void setResourceIds(Collection<String> resourceIds) {
            this.resourceIds = ValueStringListCopier.copy(resourceIds);
        }

        public final String getResourceTypeAsString() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(FlowLogsResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getTrafficTypeAsString() {
            return this.trafficType;
        }

        @Override
        public final Builder trafficType(String trafficType) {
            this.trafficType = trafficType;
            return this;
        }

        @Override
        public final Builder trafficType(TrafficType trafficType) {
            this.trafficType(trafficType == null ? null : trafficType.toString());
            return this;
        }

        public final void setTrafficType(String trafficType) {
            this.trafficType = trafficType;
        }

        public final String getLogDestinationTypeAsString() {
            return this.logDestinationType;
        }

        @Override
        public final Builder logDestinationType(String logDestinationType) {
            this.logDestinationType = logDestinationType;
            return this;
        }

        @Override
        public final Builder logDestinationType(LogDestinationType logDestinationType) {
            this.logDestinationType(logDestinationType == null ? null : logDestinationType.toString());
            return this;
        }

        public final void setLogDestinationType(String logDestinationType) {
            this.logDestinationType = logDestinationType;
        }

        public final String getLogDestination() {
            return this.logDestination;
        }

        @Override
        public final Builder logDestination(String logDestination) {
            this.logDestination = logDestination;
            return this;
        }

        public final void setLogDestination(String logDestination) {
            this.logDestination = logDestination;
        }

        public final String getLogFormat() {
            return this.logFormat;
        }

        @Override
        public final Builder logFormat(String logFormat) {
            this.logFormat = logFormat;
            return this;
        }

        public final void setLogFormat(String logFormat) {
            this.logFormat = logFormat;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFlowLogsRequest build() {
            return new CreateFlowLogsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFlowLogsRequest> {
        public Builder clientToken(String var1);

        public Builder deliverLogsPermissionArn(String var1);

        public Builder logGroupName(String var1);

        public Builder resourceIds(Collection<String> var1);

        public Builder resourceIds(String ... var1);

        public Builder resourceType(String var1);

        public Builder resourceType(FlowLogsResourceType var1);

        public Builder trafficType(String var1);

        public Builder trafficType(TrafficType var1);

        public Builder logDestinationType(String var1);

        public Builder logDestinationType(LogDestinationType var1);

        public Builder logDestination(String var1);

        public Builder logFormat(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

