/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.EbsInstanceBlockDevice;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceBlockDeviceMapping
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceBlockDeviceMapping> {
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceBlockDeviceMapping.getter(InstanceBlockDeviceMapping::deviceName)).setter(InstanceBlockDeviceMapping.setter(Builder::deviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").unmarshallLocationName("deviceName").build()}).build();
    private static final SdkField<EbsInstanceBlockDevice> EBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(InstanceBlockDeviceMapping.getter(InstanceBlockDeviceMapping::ebs)).setter(InstanceBlockDeviceMapping.setter(Builder::ebs)).constructor(EbsInstanceBlockDevice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ebs").unmarshallLocationName("ebs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_NAME_FIELD, EBS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String deviceName;
    private final EbsInstanceBlockDevice ebs;

    private InstanceBlockDeviceMapping(BuilderImpl builder) {
        this.deviceName = builder.deviceName;
        this.ebs = builder.ebs;
    }

    public String deviceName() {
        return this.deviceName;
    }

    public EbsInstanceBlockDevice ebs() {
        return this.ebs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceBlockDeviceMapping)) {
            return false;
        }
        InstanceBlockDeviceMapping other = (InstanceBlockDeviceMapping)obj;
        return Objects.equals(this.deviceName(), other.deviceName()) && Objects.equals(this.ebs(), other.ebs());
    }

    public String toString() {
        return ToString.builder((String)"InstanceBlockDeviceMapping").add("DeviceName", (Object)this.deviceName()).add("Ebs", (Object)this.ebs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceName": {
                return Optional.ofNullable(clazz.cast(this.deviceName()));
            }
            case "Ebs": {
                return Optional.ofNullable(clazz.cast(this.ebs()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceBlockDeviceMapping, T> g) {
        return obj -> g.apply((InstanceBlockDeviceMapping)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deviceName;
        private EbsInstanceBlockDevice ebs;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceBlockDeviceMapping model) {
            this.deviceName(model.deviceName);
            this.ebs(model.ebs);
        }

        public final String getDeviceName() {
            return this.deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final EbsInstanceBlockDevice.Builder getEbs() {
            return this.ebs != null ? this.ebs.toBuilder() : null;
        }

        @Override
        public final Builder ebs(EbsInstanceBlockDevice ebs) {
            this.ebs = ebs;
            return this;
        }

        public final void setEbs(EbsInstanceBlockDevice.BuilderImpl ebs) {
            this.ebs = ebs != null ? ebs.build() : null;
        }

        public InstanceBlockDeviceMapping build() {
            return new InstanceBlockDeviceMapping(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceBlockDeviceMapping> {
        public Builder deviceName(String var1);

        public Builder ebs(EbsInstanceBlockDevice var1);

        default public Builder ebs(Consumer<EbsInstanceBlockDevice.Builder> ebs) {
            return this.ebs((EbsInstanceBlockDevice)((EbsInstanceBlockDevice.Builder)EbsInstanceBlockDevice.builder().applyMutation(ebs)).build());
        }
    }
}

