/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.VolumeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchTemplateEbsBlockDevice
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LaunchTemplateEbsBlockDevice> {
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(LaunchTemplateEbsBlockDevice.getter(LaunchTemplateEbsBlockDevice::encrypted)).setter(LaunchTemplateEbsBlockDevice.setter(Builder::encrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").unmarshallLocationName("encrypted").build()}).build();
    private static final SdkField<Boolean> DELETE_ON_TERMINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(LaunchTemplateEbsBlockDevice.getter(LaunchTemplateEbsBlockDevice::deleteOnTermination)).setter(LaunchTemplateEbsBlockDevice.setter(Builder::deleteOnTermination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteOnTermination").unmarshallLocationName("deleteOnTermination").build()}).build();
    private static final SdkField<Integer> IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(LaunchTemplateEbsBlockDevice.getter(LaunchTemplateEbsBlockDevice::iops)).setter(LaunchTemplateEbsBlockDevice.setter(Builder::iops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").unmarshallLocationName("iops").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LaunchTemplateEbsBlockDevice.getter(LaunchTemplateEbsBlockDevice::kmsKeyId)).setter(LaunchTemplateEbsBlockDevice.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").unmarshallLocationName("kmsKeyId").build()}).build();
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LaunchTemplateEbsBlockDevice.getter(LaunchTemplateEbsBlockDevice::snapshotId)).setter(LaunchTemplateEbsBlockDevice.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").unmarshallLocationName("snapshotId").build()}).build();
    private static final SdkField<Integer> VOLUME_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(LaunchTemplateEbsBlockDevice.getter(LaunchTemplateEbsBlockDevice::volumeSize)).setter(LaunchTemplateEbsBlockDevice.setter(Builder::volumeSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSize").unmarshallLocationName("volumeSize").build()}).build();
    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LaunchTemplateEbsBlockDevice.getter(LaunchTemplateEbsBlockDevice::volumeTypeAsString)).setter(LaunchTemplateEbsBlockDevice.setter(Builder::volumeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeType").unmarshallLocationName("volumeType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTED_FIELD, DELETE_ON_TERMINATION_FIELD, IOPS_FIELD, KMS_KEY_ID_FIELD, SNAPSHOT_ID_FIELD, VOLUME_SIZE_FIELD, VOLUME_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean encrypted;
    private final Boolean deleteOnTermination;
    private final Integer iops;
    private final String kmsKeyId;
    private final String snapshotId;
    private final Integer volumeSize;
    private final String volumeType;

    private LaunchTemplateEbsBlockDevice(BuilderImpl builder) {
        this.encrypted = builder.encrypted;
        this.deleteOnTermination = builder.deleteOnTermination;
        this.iops = builder.iops;
        this.kmsKeyId = builder.kmsKeyId;
        this.snapshotId = builder.snapshotId;
        this.volumeSize = builder.volumeSize;
        this.volumeType = builder.volumeType;
    }

    public Boolean encrypted() {
        return this.encrypted;
    }

    public Boolean deleteOnTermination() {
        return this.deleteOnTermination;
    }

    public Integer iops() {
        return this.iops;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public String snapshotId() {
        return this.snapshotId;
    }

    public Integer volumeSize() {
        return this.volumeSize;
    }

    public VolumeType volumeType() {
        return VolumeType.fromValue(this.volumeType);
    }

    public String volumeTypeAsString() {
        return this.volumeType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteOnTermination());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplateEbsBlockDevice)) {
            return false;
        }
        LaunchTemplateEbsBlockDevice other = (LaunchTemplateEbsBlockDevice)obj;
        return Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.deleteOnTermination(), other.deleteOnTermination()) && Objects.equals(this.iops(), other.iops()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.volumeSize(), other.volumeSize()) && Objects.equals(this.volumeTypeAsString(), other.volumeTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"LaunchTemplateEbsBlockDevice").add("Encrypted", (Object)this.encrypted()).add("DeleteOnTermination", (Object)this.deleteOnTermination()).add("Iops", (Object)this.iops()).add("KmsKeyId", (Object)this.kmsKeyId()).add("SnapshotId", (Object)this.snapshotId()).add("VolumeSize", (Object)this.volumeSize()).add("VolumeType", (Object)this.volumeTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
            case "DeleteOnTermination": {
                return Optional.ofNullable(clazz.cast(this.deleteOnTermination()));
            }
            case "Iops": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "VolumeSize": {
                return Optional.ofNullable(clazz.cast(this.volumeSize()));
            }
            case "VolumeType": {
                return Optional.ofNullable(clazz.cast(this.volumeTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchTemplateEbsBlockDevice, T> g) {
        return obj -> g.apply((LaunchTemplateEbsBlockDevice)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean encrypted;
        private Boolean deleteOnTermination;
        private Integer iops;
        private String kmsKeyId;
        private String snapshotId;
        private Integer volumeSize;
        private String volumeType;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplateEbsBlockDevice model) {
            this.encrypted(model.encrypted);
            this.deleteOnTermination(model.deleteOnTermination);
            this.iops(model.iops);
            this.kmsKeyId(model.kmsKeyId);
            this.snapshotId(model.snapshotId);
            this.volumeSize(model.volumeSize);
            this.volumeType(model.volumeType);
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final Boolean getDeleteOnTermination() {
            return this.deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        public final Integer getIops() {
            return this.iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final Integer getVolumeSize() {
            return this.volumeSize;
        }

        @Override
        public final Builder volumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        public final void setVolumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
        }

        public final String getVolumeType() {
            return this.volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(VolumeType volumeType) {
            this.volumeType(volumeType.toString());
            return this;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        public LaunchTemplateEbsBlockDevice build() {
            return new LaunchTemplateEbsBlockDevice(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LaunchTemplateEbsBlockDevice> {
        public Builder encrypted(Boolean var1);

        public Builder deleteOnTermination(Boolean var1);

        public Builder iops(Integer var1);

        public Builder kmsKeyId(String var1);

        public Builder snapshotId(String var1);

        public Builder volumeSize(Integer var1);

        public Builder volumeType(String var1);

        public Builder volumeType(VolumeType var1);
    }
}

