/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.PurchaseRequest;

public class PurchaseRequestUnmarshaller
implements Unmarshaller<PurchaseRequest, StaxUnmarshallerContext> {
    private static final PurchaseRequestUnmarshaller INSTANCE = new PurchaseRequestUnmarshaller();

    public PurchaseRequest unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        PurchaseRequest.Builder purchaseRequest = PurchaseRequest.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("InstanceCount", targetDepth)) {
                    purchaseRequest.instanceCount(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("PurchaseToken", targetDepth)) continue;
                purchaseRequest.purchaseToken(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (PurchaseRequest)purchaseRequest.build();
    }

    public static PurchaseRequestUnmarshaller getInstance() {
        return INSTANCE;
    }
}

