/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.InternetGateway;
import software.amazon.awssdk.services.ec2.model.InternetGatewayAttachment;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.transform.InternetGatewayAttachmentUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.TagUnmarshaller;

public class InternetGatewayUnmarshaller
implements Unmarshaller<InternetGateway, StaxUnmarshallerContext> {
    private static final InternetGatewayUnmarshaller INSTANCE = new InternetGatewayUnmarshaller();

    public InternetGateway unmarshall(StaxUnmarshallerContext context) throws Exception {
        InternetGateway.Builder internetGateway;
        block8: {
            internetGateway = InternetGateway.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<InternetGatewayAttachment> attachments = null;
            ArrayList<Tag> tags = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    internetGateway.attachments(attachments);
                    internetGateway.tags(tags);
                    break block8;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("attachmentSet", targetDepth)) {
                        attachments = new ArrayList<InternetGatewayAttachment>();
                        continue;
                    }
                    if (context.testExpression("attachmentSet/item", targetDepth)) {
                        attachments.add(InternetGatewayAttachmentUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("internetGatewayId", targetDepth)) {
                        internetGateway.internetGatewayId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("tagSet", targetDepth)) {
                        tags = new ArrayList<Tag>();
                        continue;
                    }
                    if (!context.testExpression("tagSet/item", targetDepth)) continue;
                    tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            internetGateway.attachments(attachments);
            internetGateway.tags(tags);
        }
        return (InternetGateway)internetGateway.build();
    }

    public static InternetGatewayUnmarshaller getInstance() {
        return INSTANCE;
    }
}

