/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesModificationsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeVolumesModificationsRequestMarshaller
implements Marshaller<Request<DescribeVolumesModificationsRequest>, DescribeVolumesModificationsRequest> {
    public Request<DescribeVolumesModificationsRequest> marshall(DescribeVolumesModificationsRequest describeVolumesModificationsRequest) {
        List<Filter> describeVolumesModificationsRequestFiltersList;
        if (describeVolumesModificationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeVolumesModificationsRequest, "EC2Client");
        request.addParameter("Action", "DescribeVolumesModifications");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> describeVolumesModificationsRequestVolumeIdsList = describeVolumesModificationsRequest.volumeIds();
        if (describeVolumesModificationsRequestVolumeIdsList != null) {
            int volumeIdsListIndex = 1;
            for (String describeVolumesModificationsRequestVolumeIdsListValue : describeVolumesModificationsRequestVolumeIdsList) {
                if (describeVolumesModificationsRequestVolumeIdsListValue != null) {
                    request.addParameter("VolumeId." + volumeIdsListIndex, StringUtils.fromString((String)describeVolumesModificationsRequestVolumeIdsListValue));
                }
                ++volumeIdsListIndex;
            }
        }
        if ((describeVolumesModificationsRequestFiltersList = describeVolumesModificationsRequest.filters()) != null) {
            int filtersListIndex = 1;
            for (Filter describeVolumesModificationsRequestFiltersListValue : describeVolumesModificationsRequestFiltersList) {
                List<String> filterValuesList;
                if (describeVolumesModificationsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeVolumesModificationsRequestFiltersListValue.name()));
                }
                if ((filterValuesList = describeVolumesModificationsRequestFiltersListValue.values()) != null) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeVolumesModificationsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeVolumesModificationsRequest.nextToken()));
        }
        if (describeVolumesModificationsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeVolumesModificationsRequest.maxResults()));
        }
        return request;
    }
}

