/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DescribeImageAttributeRequest;

public class DescribeImageAttributeRequestMarshaller
implements Marshaller<Request<DescribeImageAttributeRequest>, DescribeImageAttributeRequest> {
    public Request<DescribeImageAttributeRequest> marshall(DescribeImageAttributeRequest describeImageAttributeRequest) {
        if (describeImageAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeImageAttributeRequest, "EC2Client");
        request.addParameter("Action", "DescribeImageAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeImageAttributeRequest.attributeString() != null) {
            request.addParameter("Attribute", StringUtils.fromString((String)describeImageAttributeRequest.attributeString()));
        }
        if (describeImageAttributeRequest.imageId() != null) {
            request.addParameter("ImageId", StringUtils.fromString((String)describeImageAttributeRequest.imageId()));
        }
        return request;
    }
}

