/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.ConversionTask;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.transform.ImportInstanceTaskDetailsUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ImportVolumeTaskDetailsUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.TagUnmarshaller;

public class ConversionTaskUnmarshaller
implements Unmarshaller<ConversionTask, StaxUnmarshallerContext> {
    private static final ConversionTaskUnmarshaller INSTANCE = new ConversionTaskUnmarshaller();

    public ConversionTask unmarshall(StaxUnmarshallerContext context) throws Exception {
        ConversionTask.Builder conversionTask;
        block11: {
            conversionTask = ConversionTask.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<Tag> tags = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    conversionTask.tags(tags);
                    break block11;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("conversionTaskId", targetDepth)) {
                        conversionTask.conversionTaskId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("expirationTime", targetDepth)) {
                        conversionTask.expirationTime(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("importInstance", targetDepth)) {
                        conversionTask.importInstance(ImportInstanceTaskDetailsUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("importVolume", targetDepth)) {
                        conversionTask.importVolume(ImportVolumeTaskDetailsUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("state", targetDepth)) {
                        conversionTask.state(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("statusMessage", targetDepth)) {
                        conversionTask.statusMessage(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("tagSet", targetDepth)) {
                        tags = new ArrayList<Tag>();
                        continue;
                    }
                    if (!context.testExpression("tagSet/item", targetDepth)) continue;
                    tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            conversionTask.tags(tags);
        }
        return (ConversionTask)conversionTask.build();
    }

    public static ConversionTaskUnmarshaller getInstance() {
        return INSTANCE;
    }
}

