/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.ec2.EC2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesResponse;
import software.amazon.awssdk.services.ec2.model.Volume;

public class DescribeVolumesPublisher
implements SdkPublisher<DescribeVolumesResponse> {
    private final EC2AsyncClient client;
    private final DescribeVolumesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeVolumesPublisher(EC2AsyncClient client, DescribeVolumesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeVolumesPublisher(EC2AsyncClient client, DescribeVolumesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeVolumesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeVolumesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<Volume> volumes() {
        Function<DescribeVolumesResponse, Iterator> getIterator = response -> {
            if (response != null && response.volumes() != null) {
                return response.volumes().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeVolumesResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeVolumesPublisher resume(DescribeVolumesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeVolumesPublisher(this.client, (DescribeVolumesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeVolumesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeVolumesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeVolumesResponseFetcher
    implements AsyncPageFetcher<DescribeVolumesResponse> {
        private DescribeVolumesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVolumesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<DescribeVolumesResponse> nextPage(DescribeVolumesResponse previousPage) {
            if (previousPage == null) {
                return DescribeVolumesPublisher.this.client.describeVolumes(DescribeVolumesPublisher.this.firstRequest);
            }
            return DescribeVolumesPublisher.this.client.describeVolumes((DescribeVolumesRequest)((Object)DescribeVolumesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

