/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.ec2.EC2Client;
import software.amazon.awssdk.services.ec2.model.DescribeTagsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTagsResponse;
import software.amazon.awssdk.services.ec2.model.TagDescription;

public class DescribeTagsIterable
implements SdkIterable<DescribeTagsResponse> {
    private final EC2Client client;
    private final DescribeTagsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeTagsIterable(EC2Client client, DescribeTagsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeTagsResponseFetcher();
    }

    public Iterator<DescribeTagsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<TagDescription> tags() {
        Function<DescribeTagsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tags() != null) {
                return response.tags().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeTagsIterable resume(DescribeTagsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeTagsIterable(this.client, (DescribeTagsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeTagsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeTagsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeTagsResponseFetcher
    implements SyncPageFetcher<DescribeTagsResponse> {
        private DescribeTagsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTagsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeTagsResponse nextPage(DescribeTagsResponse previousPage) {
            if (previousPage == null) {
                return DescribeTagsIterable.this.client.describeTags(DescribeTagsIterable.this.firstRequest);
            }
            return DescribeTagsIterable.this.client.describeTags((DescribeTagsRequest)((Object)DescribeTagsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

