/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.ec2.EC2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotsResponse;
import software.amazon.awssdk.services.ec2.model.Snapshot;

public class DescribeSnapshotsPublisher
implements SdkPublisher<DescribeSnapshotsResponse> {
    private final EC2AsyncClient client;
    private final DescribeSnapshotsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeSnapshotsPublisher(EC2AsyncClient client, DescribeSnapshotsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeSnapshotsPublisher(EC2AsyncClient client, DescribeSnapshotsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeSnapshotsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeSnapshotsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<Snapshot> snapshots() {
        Function<DescribeSnapshotsResponse, Iterator> getIterator = response -> {
            if (response != null && response.snapshots() != null) {
                return response.snapshots().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeSnapshotsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeSnapshotsPublisher resume(DescribeSnapshotsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeSnapshotsPublisher(this.client, (DescribeSnapshotsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeSnapshotsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeSnapshotsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeSnapshotsResponseFetcher
    implements AsyncPageFetcher<DescribeSnapshotsResponse> {
        private DescribeSnapshotsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSnapshotsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<DescribeSnapshotsResponse> nextPage(DescribeSnapshotsResponse previousPage) {
            if (previousPage == null) {
                return DescribeSnapshotsPublisher.this.client.describeSnapshots(DescribeSnapshotsPublisher.this.firstRequest);
            }
            return DescribeSnapshotsPublisher.this.client.describeSnapshots((DescribeSnapshotsRequest)((Object)DescribeSnapshotsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

