/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.PrivateIpAddressStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UnassignPrivateIpAddressesRequest
extends EC2Request
implements ToCopyableBuilder<Builder, UnassignPrivateIpAddressesRequest> {
    private final String networkInterfaceId;
    private final List<String> privateIpAddresses;

    private UnassignPrivateIpAddressesRequest(BuilderImpl builder) {
        super(builder);
        this.networkInterfaceId = builder.networkInterfaceId;
        this.privateIpAddresses = builder.privateIpAddresses;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public List<String> privateIpAddresses() {
        return this.privateIpAddresses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIpAddresses());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnassignPrivateIpAddressesRequest)) {
            return false;
        }
        UnassignPrivateIpAddressesRequest other = (UnassignPrivateIpAddressesRequest)((Object)obj);
        return Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.privateIpAddresses(), other.privateIpAddresses());
    }

    public String toString() {
        return ToString.builder((String)"UnassignPrivateIpAddressesRequest").add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("PrivateIpAddresses", this.privateIpAddresses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkInterfaceId": {
                return Optional.of(clazz.cast(this.networkInterfaceId()));
            }
            case "PrivateIpAddresses": {
                return Optional.of(clazz.cast(this.privateIpAddresses()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String networkInterfaceId;
        private List<String> privateIpAddresses;

        private BuilderImpl() {
        }

        private BuilderImpl(UnassignPrivateIpAddressesRequest model) {
            this.networkInterfaceId(model.networkInterfaceId);
            this.privateIpAddresses(model.privateIpAddresses);
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final Collection<String> getPrivateIpAddresses() {
            return this.privateIpAddresses;
        }

        @Override
        public final Builder privateIpAddresses(Collection<String> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressStringListCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(String ... privateIpAddresses) {
            this.privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        public final void setPrivateIpAddresses(Collection<String> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressStringListCopier.copy(privateIpAddresses);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UnassignPrivateIpAddressesRequest build() {
            return new UnassignPrivateIpAddressesRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, UnassignPrivateIpAddressesRequest> {
        public Builder networkInterfaceId(String var1);

        public Builder privateIpAddresses(Collection<String> var1);

        public Builder privateIpAddresses(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

