/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.SnapshotState;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Snapshot
implements ToCopyableBuilder<Builder, Snapshot> {
    private final String dataEncryptionKeyId;
    private final String description;
    private final Boolean encrypted;
    private final String kmsKeyId;
    private final String ownerId;
    private final String progress;
    private final String snapshotId;
    private final Instant startTime;
    private final String state;
    private final String stateMessage;
    private final String volumeId;
    private final Integer volumeSize;
    private final String ownerAlias;
    private final List<Tag> tags;

    private Snapshot(BuilderImpl builder) {
        this.dataEncryptionKeyId = builder.dataEncryptionKeyId;
        this.description = builder.description;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.ownerId = builder.ownerId;
        this.progress = builder.progress;
        this.snapshotId = builder.snapshotId;
        this.startTime = builder.startTime;
        this.state = builder.state;
        this.stateMessage = builder.stateMessage;
        this.volumeId = builder.volumeId;
        this.volumeSize = builder.volumeSize;
        this.ownerAlias = builder.ownerAlias;
        this.tags = builder.tags;
    }

    public String dataEncryptionKeyId() {
        return this.dataEncryptionKeyId;
    }

    public String description() {
        return this.description;
    }

    public Boolean encrypted() {
        return this.encrypted;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public String ownerId() {
        return this.ownerId;
    }

    public String progress() {
        return this.progress;
    }

    public String snapshotId() {
        return this.snapshotId;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public SnapshotState state() {
        return SnapshotState.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public String stateMessage() {
        return this.stateMessage;
    }

    public String volumeId() {
        return this.volumeId;
    }

    public Integer volumeSize() {
        return this.volumeSize;
    }

    public String ownerAlias() {
        return this.ownerAlias;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataEncryptionKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.progress());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Snapshot)) {
            return false;
        }
        Snapshot other = (Snapshot)obj;
        return Objects.equals(this.dataEncryptionKeyId(), other.dataEncryptionKeyId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.progress(), other.progress()) && Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.stateString(), other.stateString()) && Objects.equals(this.stateMessage(), other.stateMessage()) && Objects.equals(this.volumeId(), other.volumeId()) && Objects.equals(this.volumeSize(), other.volumeSize()) && Objects.equals(this.ownerAlias(), other.ownerAlias()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"Snapshot").add("DataEncryptionKeyId", (Object)this.dataEncryptionKeyId()).add("Description", (Object)this.description()).add("Encrypted", (Object)this.encrypted()).add("KmsKeyId", (Object)this.kmsKeyId()).add("OwnerId", (Object)this.ownerId()).add("Progress", (Object)this.progress()).add("SnapshotId", (Object)this.snapshotId()).add("StartTime", (Object)this.startTime()).add("State", (Object)this.stateString()).add("StateMessage", (Object)this.stateMessage()).add("VolumeId", (Object)this.volumeId()).add("VolumeSize", (Object)this.volumeSize()).add("OwnerAlias", (Object)this.ownerAlias()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataEncryptionKeyId": {
                return Optional.of(clazz.cast(this.dataEncryptionKeyId()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Encrypted": {
                return Optional.of(clazz.cast(this.encrypted()));
            }
            case "KmsKeyId": {
                return Optional.of(clazz.cast(this.kmsKeyId()));
            }
            case "OwnerId": {
                return Optional.of(clazz.cast(this.ownerId()));
            }
            case "Progress": {
                return Optional.of(clazz.cast(this.progress()));
            }
            case "SnapshotId": {
                return Optional.of(clazz.cast(this.snapshotId()));
            }
            case "StartTime": {
                return Optional.of(clazz.cast(this.startTime()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.stateString()));
            }
            case "StateMessage": {
                return Optional.of(clazz.cast(this.stateMessage()));
            }
            case "VolumeId": {
                return Optional.of(clazz.cast(this.volumeId()));
            }
            case "VolumeSize": {
                return Optional.of(clazz.cast(this.volumeSize()));
            }
            case "OwnerAlias": {
                return Optional.of(clazz.cast(this.ownerAlias()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String dataEncryptionKeyId;
        private String description;
        private Boolean encrypted;
        private String kmsKeyId;
        private String ownerId;
        private String progress;
        private String snapshotId;
        private Instant startTime;
        private String state;
        private String stateMessage;
        private String volumeId;
        private Integer volumeSize;
        private String ownerAlias;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(Snapshot model) {
            this.dataEncryptionKeyId(model.dataEncryptionKeyId);
            this.description(model.description);
            this.encrypted(model.encrypted);
            this.kmsKeyId(model.kmsKeyId);
            this.ownerId(model.ownerId);
            this.progress(model.progress);
            this.snapshotId(model.snapshotId);
            this.startTime(model.startTime);
            this.state(model.state);
            this.stateMessage(model.stateMessage);
            this.volumeId(model.volumeId);
            this.volumeSize(model.volumeSize);
            this.ownerAlias(model.ownerAlias);
            this.tags(model.tags);
        }

        public final String getDataEncryptionKeyId() {
            return this.dataEncryptionKeyId;
        }

        @Override
        public final Builder dataEncryptionKeyId(String dataEncryptionKeyId) {
            this.dataEncryptionKeyId = dataEncryptionKeyId;
            return this;
        }

        public final void setDataEncryptionKeyId(String dataEncryptionKeyId) {
            this.dataEncryptionKeyId = dataEncryptionKeyId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getProgress() {
            return this.progress;
        }

        @Override
        public final Builder progress(String progress) {
            this.progress = progress;
            return this;
        }

        public final void setProgress(String progress) {
            this.progress = progress;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SnapshotState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStateMessage() {
            return this.stateMessage;
        }

        @Override
        public final Builder stateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
            return this;
        }

        public final void setStateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        public final Integer getVolumeSize() {
            return this.volumeSize;
        }

        @Override
        public final Builder volumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        public final void setVolumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
        }

        public final String getOwnerAlias() {
            return this.ownerAlias;
        }

        @Override
        public final Builder ownerAlias(String ownerAlias) {
            this.ownerAlias = ownerAlias;
            return this;
        }

        public final void setOwnerAlias(String ownerAlias) {
            this.ownerAlias = ownerAlias;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public Snapshot build() {
            return new Snapshot(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Snapshot> {
        public Builder dataEncryptionKeyId(String var1);

        public Builder description(String var1);

        public Builder encrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder ownerId(String var1);

        public Builder progress(String var1);

        public Builder snapshotId(String var1);

        public Builder startTime(Instant var1);

        public Builder state(String var1);

        public Builder state(SnapshotState var1);

        public Builder stateMessage(String var1);

        public Builder volumeId(String var1);

        public Builder volumeSize(Integer var1);

        public Builder ownerAlias(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

