/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.LaunchPermissionModifications;
import software.amazon.awssdk.services.ec2.model.OperationType;
import software.amazon.awssdk.services.ec2.model.ProductCodeStringListCopier;
import software.amazon.awssdk.services.ec2.model.UserGroupStringListCopier;
import software.amazon.awssdk.services.ec2.model.UserIdStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyImageAttributeRequest
extends EC2Request
implements ToCopyableBuilder<Builder, ModifyImageAttributeRequest> {
    private final String attribute;
    private final String description;
    private final String imageId;
    private final LaunchPermissionModifications launchPermission;
    private final String operationType;
    private final List<String> productCodes;
    private final List<String> userGroups;
    private final List<String> userIds;
    private final String value;

    private ModifyImageAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.attribute = builder.attribute;
        this.description = builder.description;
        this.imageId = builder.imageId;
        this.launchPermission = builder.launchPermission;
        this.operationType = builder.operationType;
        this.productCodes = builder.productCodes;
        this.userGroups = builder.userGroups;
        this.userIds = builder.userIds;
        this.value = builder.value;
    }

    public String attribute() {
        return this.attribute;
    }

    public String description() {
        return this.description;
    }

    public String imageId() {
        return this.imageId;
    }

    public LaunchPermissionModifications launchPermission() {
        return this.launchPermission;
    }

    public OperationType operationType() {
        return OperationType.fromValue(this.operationType);
    }

    public String operationTypeString() {
        return this.operationType;
    }

    public List<String> productCodes() {
        return this.productCodes;
    }

    public List<String> userGroups() {
        return this.userGroups;
    }

    public List<String> userIds() {
        return this.userIds;
    }

    public String value() {
        return this.value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attribute());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchPermission());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.productCodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.userGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.userIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyImageAttributeRequest)) {
            return false;
        }
        ModifyImageAttributeRequest other = (ModifyImageAttributeRequest)((Object)obj);
        return Objects.equals(this.attribute(), other.attribute()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.launchPermission(), other.launchPermission()) && Objects.equals(this.operationTypeString(), other.operationTypeString()) && Objects.equals(this.productCodes(), other.productCodes()) && Objects.equals(this.userGroups(), other.userGroups()) && Objects.equals(this.userIds(), other.userIds()) && Objects.equals(this.value(), other.value());
    }

    public String toString() {
        return ToString.builder((String)"ModifyImageAttributeRequest").add("Attribute", (Object)this.attribute()).add("Description", (Object)this.description()).add("ImageId", (Object)this.imageId()).add("LaunchPermission", (Object)this.launchPermission()).add("OperationType", (Object)this.operationTypeString()).add("ProductCodes", this.productCodes()).add("UserGroups", this.userGroups()).add("UserIds", this.userIds()).add("Value", (Object)this.value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attribute": {
                return Optional.of(clazz.cast(this.attribute()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "ImageId": {
                return Optional.of(clazz.cast(this.imageId()));
            }
            case "LaunchPermission": {
                return Optional.of(clazz.cast(this.launchPermission()));
            }
            case "OperationType": {
                return Optional.of(clazz.cast(this.operationTypeString()));
            }
            case "ProductCodes": {
                return Optional.of(clazz.cast(this.productCodes()));
            }
            case "UserGroups": {
                return Optional.of(clazz.cast(this.userGroups()));
            }
            case "UserIds": {
                return Optional.of(clazz.cast(this.userIds()));
            }
            case "Value": {
                return Optional.of(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String attribute;
        private String description;
        private String imageId;
        private LaunchPermissionModifications launchPermission;
        private String operationType;
        private List<String> productCodes;
        private List<String> userGroups;
        private List<String> userIds;
        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyImageAttributeRequest model) {
            this.attribute(model.attribute);
            this.description(model.description);
            this.imageId(model.imageId);
            this.launchPermission(model.launchPermission);
            this.operationType(model.operationType);
            this.productCodes(model.productCodes);
            this.userGroups(model.userGroups);
            this.userIds(model.userIds);
            this.value(model.value);
        }

        public final String getAttribute() {
            return this.attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getImageId() {
            return this.imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final LaunchPermissionModifications.Builder getLaunchPermission() {
            return this.launchPermission != null ? this.launchPermission.toBuilder() : null;
        }

        @Override
        public final Builder launchPermission(LaunchPermissionModifications launchPermission) {
            this.launchPermission = launchPermission;
            return this;
        }

        public final void setLaunchPermission(LaunchPermissionModifications.BuilderImpl launchPermission) {
            this.launchPermission = launchPermission != null ? launchPermission.build() : null;
        }

        public final String getOperationType() {
            return this.operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        @Override
        public final Builder operationType(OperationType operationType) {
            this.operationType(operationType.toString());
            return this;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        public final Collection<String> getProductCodes() {
            return this.productCodes;
        }

        @Override
        public final Builder productCodes(Collection<String> productCodes) {
            this.productCodes = ProductCodeStringListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(String ... productCodes) {
            this.productCodes(Arrays.asList(productCodes));
            return this;
        }

        public final void setProductCodes(Collection<String> productCodes) {
            this.productCodes = ProductCodeStringListCopier.copy(productCodes);
        }

        public final Collection<String> getUserGroups() {
            return this.userGroups;
        }

        @Override
        public final Builder userGroups(Collection<String> userGroups) {
            this.userGroups = UserGroupStringListCopier.copy(userGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userGroups(String ... userGroups) {
            this.userGroups(Arrays.asList(userGroups));
            return this;
        }

        public final void setUserGroups(Collection<String> userGroups) {
            this.userGroups = UserGroupStringListCopier.copy(userGroups);
        }

        public final Collection<String> getUserIds() {
            return this.userIds;
        }

        @Override
        public final Builder userIds(Collection<String> userIds) {
            this.userIds = UserIdStringListCopier.copy(userIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIds(String ... userIds) {
            this.userIds(Arrays.asList(userIds));
            return this;
        }

        public final void setUserIds(Collection<String> userIds) {
            this.userIds = UserIdStringListCopier.copy(userIds);
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ModifyImageAttributeRequest build() {
            return new ModifyImageAttributeRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, ModifyImageAttributeRequest> {
        public Builder attribute(String var1);

        public Builder description(String var1);

        public Builder imageId(String var1);

        public Builder launchPermission(LaunchPermissionModifications var1);

        default public Builder launchPermission(Consumer<LaunchPermissionModifications.Builder> launchPermission) {
            return this.launchPermission((LaunchPermissionModifications)((LaunchPermissionModifications.Builder)LaunchPermissionModifications.builder().apply(launchPermission)).build());
        }

        public Builder operationType(String var1);

        public Builder operationType(OperationType var1);

        public Builder productCodes(Collection<String> var1);

        public Builder productCodes(String ... var1);

        public Builder userGroups(Collection<String> var1);

        public Builder userGroups(String ... var1);

        public Builder userIds(Collection<String> var1);

        public Builder userIds(String ... var1);

        public Builder value(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

