/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.ExportEnvironment;
import software.amazon.awssdk.services.ec2.model.ExportToS3TaskSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateInstanceExportTaskRequest
extends EC2Request
implements ToCopyableBuilder<Builder, CreateInstanceExportTaskRequest> {
    private final String description;
    private final ExportToS3TaskSpecification exportToS3Task;
    private final String instanceId;
    private final String targetEnvironment;

    private CreateInstanceExportTaskRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.exportToS3Task = builder.exportToS3Task;
        this.instanceId = builder.instanceId;
        this.targetEnvironment = builder.targetEnvironment;
    }

    public String description() {
        return this.description;
    }

    public ExportToS3TaskSpecification exportToS3Task() {
        return this.exportToS3Task;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public ExportEnvironment targetEnvironment() {
        return ExportEnvironment.fromValue(this.targetEnvironment);
    }

    public String targetEnvironmentString() {
        return this.targetEnvironment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportToS3Task());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetEnvironmentString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstanceExportTaskRequest)) {
            return false;
        }
        CreateInstanceExportTaskRequest other = (CreateInstanceExportTaskRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.exportToS3Task(), other.exportToS3Task()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.targetEnvironmentString(), other.targetEnvironmentString());
    }

    public String toString() {
        return ToString.builder((String)"CreateInstanceExportTaskRequest").add("Description", (Object)this.description()).add("ExportToS3Task", (Object)this.exportToS3Task()).add("InstanceId", (Object)this.instanceId()).add("TargetEnvironment", (Object)this.targetEnvironmentString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "ExportToS3Task": {
                return Optional.of(clazz.cast(this.exportToS3Task()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "TargetEnvironment": {
                return Optional.of(clazz.cast(this.targetEnvironmentString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String description;
        private ExportToS3TaskSpecification exportToS3Task;
        private String instanceId;
        private String targetEnvironment;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstanceExportTaskRequest model) {
            this.description(model.description);
            this.exportToS3Task(model.exportToS3Task);
            this.instanceId(model.instanceId);
            this.targetEnvironment(model.targetEnvironment);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final ExportToS3TaskSpecification.Builder getExportToS3Task() {
            return this.exportToS3Task != null ? this.exportToS3Task.toBuilder() : null;
        }

        @Override
        public final Builder exportToS3Task(ExportToS3TaskSpecification exportToS3Task) {
            this.exportToS3Task = exportToS3Task;
            return this;
        }

        public final void setExportToS3Task(ExportToS3TaskSpecification.BuilderImpl exportToS3Task) {
            this.exportToS3Task = exportToS3Task != null ? exportToS3Task.build() : null;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getTargetEnvironment() {
            return this.targetEnvironment;
        }

        @Override
        public final Builder targetEnvironment(String targetEnvironment) {
            this.targetEnvironment = targetEnvironment;
            return this;
        }

        @Override
        public final Builder targetEnvironment(ExportEnvironment targetEnvironment) {
            this.targetEnvironment(targetEnvironment.toString());
            return this;
        }

        public final void setTargetEnvironment(String targetEnvironment) {
            this.targetEnvironment = targetEnvironment;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateInstanceExportTaskRequest build() {
            return new CreateInstanceExportTaskRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, CreateInstanceExportTaskRequest> {
        public Builder description(String var1);

        public Builder exportToS3Task(ExportToS3TaskSpecification var1);

        default public Builder exportToS3Task(Consumer<ExportToS3TaskSpecification.Builder> exportToS3Task) {
            return this.exportToS3Task((ExportToS3TaskSpecification)((ExportToS3TaskSpecification.Builder)ExportToS3TaskSpecification.builder().apply(exportToS3Task)).build());
        }

        public Builder instanceId(String var1);

        public Builder targetEnvironment(String var1);

        public Builder targetEnvironment(ExportEnvironment var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

