/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.ExportTask;
import software.amazon.awssdk.services.ec2.transform.ExportToS3TaskUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.InstanceExportDetailsUnmarshaller;

public class ExportTaskUnmarshaller
implements Unmarshaller<ExportTask, StaxUnmarshallerContext> {
    private static final ExportTaskUnmarshaller INSTANCE = new ExportTaskUnmarshaller();

    public ExportTask unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ExportTask.Builder exportTask = ExportTask.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("description", targetDepth)) {
                    exportTask.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("exportTaskId", targetDepth)) {
                    exportTask.exportTaskId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("exportToS3", targetDepth)) {
                    exportTask.exportToS3Task(ExportToS3TaskUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("instanceExport", targetDepth)) {
                    exportTask.instanceExportDetails(InstanceExportDetailsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("state", targetDepth)) {
                    exportTask.state(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("statusMessage", targetDepth)) continue;
                exportTask.statusMessage(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ExportTask)exportTask.build();
    }

    public static ExportTaskUnmarshaller getInstance() {
        return INSTANCE;
    }
}

