/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.Filter;

public class DescribeCustomerGatewaysRequestMarshaller
implements Marshaller<Request<DescribeCustomerGatewaysRequest>, DescribeCustomerGatewaysRequest> {
    public Request<DescribeCustomerGatewaysRequest> marshall(DescribeCustomerGatewaysRequest describeCustomerGatewaysRequest) {
        List<Filter> describeCustomerGatewaysRequestFiltersList;
        if (describeCustomerGatewaysRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeCustomerGatewaysRequest, "EC2Client");
        request.addParameter("Action", "DescribeCustomerGateways");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> describeCustomerGatewaysRequestCustomerGatewayIdsList = describeCustomerGatewaysRequest.customerGatewayIds();
        if (describeCustomerGatewaysRequestCustomerGatewayIdsList != null) {
            int customerGatewayIdsListIndex = 1;
            for (String describeCustomerGatewaysRequestCustomerGatewayIdsListValue : describeCustomerGatewaysRequestCustomerGatewayIdsList) {
                if (describeCustomerGatewaysRequestCustomerGatewayIdsListValue != null) {
                    request.addParameter("CustomerGatewayId." + customerGatewayIdsListIndex, StringUtils.fromString((String)describeCustomerGatewaysRequestCustomerGatewayIdsListValue));
                }
                ++customerGatewayIdsListIndex;
            }
        }
        if ((describeCustomerGatewaysRequestFiltersList = describeCustomerGatewaysRequest.filters()) != null) {
            int filtersListIndex = 1;
            for (Filter describeCustomerGatewaysRequestFiltersListValue : describeCustomerGatewaysRequestFiltersList) {
                List<String> filterValuesList;
                if (describeCustomerGatewaysRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeCustomerGatewaysRequestFiltersListValue.name()));
                }
                if ((filterValuesList = describeCustomerGatewaysRequestFiltersListValue.values()) != null) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

