/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.CreateDefaultSubnetRequest;

public class CreateDefaultSubnetRequestMarshaller
implements Marshaller<Request<CreateDefaultSubnetRequest>, CreateDefaultSubnetRequest> {
    public Request<CreateDefaultSubnetRequest> marshall(CreateDefaultSubnetRequest createDefaultSubnetRequest) {
        if (createDefaultSubnetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)createDefaultSubnetRequest, "EC2Client");
        request.addParameter("Action", "CreateDefaultSubnet");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createDefaultSubnetRequest.availabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)createDefaultSubnetRequest.availabilityZone()));
        }
        return request;
    }
}

