/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.ec2.EC2Client;
import software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.NatGateway;

public final class DescribeNatGatewaysPaginator
implements SdkIterable<DescribeNatGatewaysResponse> {
    private final EC2Client client;
    private final DescribeNatGatewaysRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeNatGatewaysPaginator(EC2Client client, DescribeNatGatewaysRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeNatGatewaysResponseFetcher();
    }

    public Iterator<DescribeNatGatewaysResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<NatGateway> natGateways() {
        Function<DescribeNatGatewaysResponse, Iterator> getIterator = response -> response != null ? response.natGateways().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeNatGatewaysResponseFetcher
    implements NextPageFetcher<DescribeNatGatewaysResponse> {
        private DescribeNatGatewaysResponseFetcher() {
        }

        public boolean hasNextPage(DescribeNatGatewaysResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeNatGatewaysResponse nextPage(DescribeNatGatewaysResponse previousPage) {
            if (previousPage == null) {
                return DescribeNatGatewaysPaginator.this.client.describeNatGateways(DescribeNatGatewaysPaginator.this.firstRequest);
            }
            return DescribeNatGatewaysPaginator.this.client.describeNatGateways((DescribeNatGatewaysRequest)((Object)DescribeNatGatewaysPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

