/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.ClassicLoadBalancer;
import software.amazon.awssdk.services.ec2.model.ClassicLoadBalancersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ClassicLoadBalancersConfig
implements ToCopyableBuilder<Builder, ClassicLoadBalancersConfig> {
    private final List<ClassicLoadBalancer> classicLoadBalancers;

    private ClassicLoadBalancersConfig(BuilderImpl builder) {
        this.classicLoadBalancers = builder.classicLoadBalancers;
    }

    public List<ClassicLoadBalancer> classicLoadBalancers() {
        return this.classicLoadBalancers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.classicLoadBalancers());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassicLoadBalancersConfig)) {
            return false;
        }
        ClassicLoadBalancersConfig other = (ClassicLoadBalancersConfig)obj;
        return Objects.equals(this.classicLoadBalancers(), other.classicLoadBalancers());
    }

    public String toString() {
        return ToString.builder((String)"ClassicLoadBalancersConfig").add("ClassicLoadBalancers", this.classicLoadBalancers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClassicLoadBalancers": {
                return Optional.of(clazz.cast(this.classicLoadBalancers()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<ClassicLoadBalancer> classicLoadBalancers;

        private BuilderImpl() {
        }

        private BuilderImpl(ClassicLoadBalancersConfig model) {
            this.classicLoadBalancers(model.classicLoadBalancers);
        }

        public final Collection<ClassicLoadBalancer.Builder> getClassicLoadBalancers() {
            return this.classicLoadBalancers != null ? (Collection)this.classicLoadBalancers.stream().map(ClassicLoadBalancer::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder classicLoadBalancers(Collection<ClassicLoadBalancer> classicLoadBalancers) {
            this.classicLoadBalancers = ClassicLoadBalancersCopier.copy(classicLoadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classicLoadBalancers(ClassicLoadBalancer ... classicLoadBalancers) {
            this.classicLoadBalancers(Arrays.asList(classicLoadBalancers));
            return this;
        }

        public final void setClassicLoadBalancers(Collection<ClassicLoadBalancer.BuilderImpl> classicLoadBalancers) {
            this.classicLoadBalancers = ClassicLoadBalancersCopier.copyFromBuilder(classicLoadBalancers);
        }

        public ClassicLoadBalancersConfig build() {
            return new ClassicLoadBalancersConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ClassicLoadBalancersConfig> {
        public Builder classicLoadBalancers(Collection<ClassicLoadBalancer> var1);

        public Builder classicLoadBalancers(ClassicLoadBalancer ... var1);
    }
}

