/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssociateAddressRequest
extends EC2Request
implements ToCopyableBuilder<Builder, AssociateAddressRequest> {
    private final String allocationId;
    private final String instanceId;
    private final String publicIp;
    private final Boolean allowReassociation;
    private final String networkInterfaceId;
    private final String privateIpAddress;

    private AssociateAddressRequest(BuilderImpl builder) {
        super(builder);
        this.allocationId = builder.allocationId;
        this.instanceId = builder.instanceId;
        this.publicIp = builder.publicIp;
        this.allowReassociation = builder.allowReassociation;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.privateIpAddress = builder.privateIpAddress;
    }

    public String allocationId() {
        return this.allocationId;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String publicIp() {
        return this.publicIp;
    }

    public Boolean allowReassociation() {
        return this.allowReassociation;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowReassociation());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIpAddress());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateAddressRequest)) {
            return false;
        }
        AssociateAddressRequest other = (AssociateAddressRequest)((Object)obj);
        return Objects.equals(this.allocationId(), other.allocationId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.publicIp(), other.publicIp()) && Objects.equals(this.allowReassociation(), other.allowReassociation()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.privateIpAddress(), other.privateIpAddress());
    }

    public String toString() {
        return ToString.builder((String)"AssociateAddressRequest").add("AllocationId", (Object)this.allocationId()).add("InstanceId", (Object)this.instanceId()).add("PublicIp", (Object)this.publicIp()).add("AllowReassociation", (Object)this.allowReassociation()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("PrivateIpAddress", (Object)this.privateIpAddress()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllocationId": {
                return Optional.of(clazz.cast(this.allocationId()));
            }
            case "InstanceId": {
                return Optional.of(clazz.cast(this.instanceId()));
            }
            case "PublicIp": {
                return Optional.of(clazz.cast(this.publicIp()));
            }
            case "AllowReassociation": {
                return Optional.of(clazz.cast(this.allowReassociation()));
            }
            case "NetworkInterfaceId": {
                return Optional.of(clazz.cast(this.networkInterfaceId()));
            }
            case "PrivateIpAddress": {
                return Optional.of(clazz.cast(this.privateIpAddress()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String allocationId;
        private String instanceId;
        private String publicIp;
        private Boolean allowReassociation;
        private String networkInterfaceId;
        private String privateIpAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateAddressRequest model) {
            this.allocationId(model.allocationId);
            this.instanceId(model.instanceId);
            this.publicIp(model.publicIp);
            this.allowReassociation(model.allowReassociation);
            this.networkInterfaceId(model.networkInterfaceId);
            this.privateIpAddress(model.privateIpAddress);
        }

        public final String getAllocationId() {
            return this.allocationId;
        }

        @Override
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getPublicIp() {
            return this.publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        public final Boolean getAllowReassociation() {
            return this.allowReassociation;
        }

        @Override
        public final Builder allowReassociation(Boolean allowReassociation) {
            this.allowReassociation = allowReassociation;
            return this;
        }

        public final void setAllowReassociation(Boolean allowReassociation) {
            this.allowReassociation = allowReassociation;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public AssociateAddressRequest build() {
            return new AssociateAddressRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, AssociateAddressRequest> {
        public Builder allocationId(String var1);

        public Builder instanceId(String var1);

        public Builder publicIp(String var1);

        public Builder allowReassociation(Boolean var1);

        public Builder networkInterfaceId(String var1);

        public Builder privateIpAddress(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

