/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfaceAttributeRequest;

public class DescribeNetworkInterfaceAttributeRequestMarshaller
implements Marshaller<Request<DescribeNetworkInterfaceAttributeRequest>, DescribeNetworkInterfaceAttributeRequest> {
    public Request<DescribeNetworkInterfaceAttributeRequest> marshall(DescribeNetworkInterfaceAttributeRequest describeNetworkInterfaceAttributeRequest) {
        if (describeNetworkInterfaceAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeNetworkInterfaceAttributeRequest, "EC2Client");
        request.addParameter("Action", "DescribeNetworkInterfaceAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeNetworkInterfaceAttributeRequest.attributeString() != null) {
            request.addParameter("Attribute", StringUtils.fromString((String)describeNetworkInterfaceAttributeRequest.attributeString()));
        }
        if (describeNetworkInterfaceAttributeRequest.networkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringUtils.fromString((String)describeNetworkInterfaceAttributeRequest.networkInterfaceId()));
        }
        return request;
    }
}

