/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.CreateCustomerGatewayRequest;

public class CreateCustomerGatewayRequestMarshaller
implements Marshaller<Request<CreateCustomerGatewayRequest>, CreateCustomerGatewayRequest> {
    public Request<CreateCustomerGatewayRequest> marshall(CreateCustomerGatewayRequest createCustomerGatewayRequest) {
        if (createCustomerGatewayRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)createCustomerGatewayRequest, "EC2Client");
        request.addParameter("Action", "CreateCustomerGateway");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createCustomerGatewayRequest.bgpAsn() != null) {
            request.addParameter("BgpAsn", StringUtils.fromInteger((Integer)createCustomerGatewayRequest.bgpAsn()));
        }
        if (createCustomerGatewayRequest.publicIp() != null) {
            request.addParameter("IpAddress", StringUtils.fromString((String)createCustomerGatewayRequest.publicIp()));
        }
        if (createCustomerGatewayRequest.typeString() != null) {
            request.addParameter("Type", StringUtils.fromString((String)createCustomerGatewayRequest.typeString()));
        }
        return request;
    }
}

