/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsRequest;

public class CancelSpotFleetRequestsRequestMarshaller
implements Marshaller<Request<CancelSpotFleetRequestsRequest>, CancelSpotFleetRequestsRequest> {
    public Request<CancelSpotFleetRequestsRequest> marshall(CancelSpotFleetRequestsRequest cancelSpotFleetRequestsRequest) {
        if (cancelSpotFleetRequestsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)cancelSpotFleetRequestsRequest, "EC2Client");
        request.addParameter("Action", "CancelSpotFleetRequests");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> cancelSpotFleetRequestsRequestSpotFleetRequestIdsList = cancelSpotFleetRequestsRequest.spotFleetRequestIds();
        if (cancelSpotFleetRequestsRequestSpotFleetRequestIdsList != null) {
            int spotFleetRequestIdsListIndex = 1;
            for (String cancelSpotFleetRequestsRequestSpotFleetRequestIdsListValue : cancelSpotFleetRequestsRequestSpotFleetRequestIdsList) {
                if (cancelSpotFleetRequestsRequestSpotFleetRequestIdsListValue != null) {
                    request.addParameter("SpotFleetRequestId." + spotFleetRequestIdsListIndex, StringUtils.fromString((String)cancelSpotFleetRequestsRequestSpotFleetRequestIdsListValue));
                }
                ++spotFleetRequestIdsListIndex;
            }
        }
        if (cancelSpotFleetRequestsRequest.terminateInstances() != null) {
            request.addParameter("TerminateInstances", StringUtils.fromBoolean((Boolean)cancelSpotFleetRequestsRequest.terminateInstances()));
        }
        return request;
    }
}

