/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.AttachNetworkInterfaceRequest;

public class AttachNetworkInterfaceRequestMarshaller
implements Marshaller<Request<AttachNetworkInterfaceRequest>, AttachNetworkInterfaceRequest> {
    public Request<AttachNetworkInterfaceRequest> marshall(AttachNetworkInterfaceRequest attachNetworkInterfaceRequest) {
        if (attachNetworkInterfaceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)attachNetworkInterfaceRequest, "EC2Client");
        request.addParameter("Action", "AttachNetworkInterface");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (attachNetworkInterfaceRequest.deviceIndex() != null) {
            request.addParameter("DeviceIndex", StringUtils.fromInteger((Integer)attachNetworkInterfaceRequest.deviceIndex()));
        }
        if (attachNetworkInterfaceRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)attachNetworkInterfaceRequest.instanceId()));
        }
        if (attachNetworkInterfaceRequest.networkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringUtils.fromString((String)attachNetworkInterfaceRequest.networkInterfaceId()));
        }
        return request;
    }
}

