/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.services.ec2.model.InstanceStateChange;
import software.amazon.awssdk.services.ec2.model.InstanceStateChangeListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StopInstancesResponse
extends EC2Response
implements ToCopyableBuilder<Builder, StopInstancesResponse> {
    private final List<InstanceStateChange> stoppingInstances;

    private StopInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.stoppingInstances = builder.stoppingInstances;
    }

    public List<InstanceStateChange> stoppingInstances() {
        return this.stoppingInstances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppingInstances());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StopInstancesResponse)) {
            return false;
        }
        StopInstancesResponse other = (StopInstancesResponse)((Object)obj);
        return Objects.equals(this.stoppingInstances(), other.stoppingInstances());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.stoppingInstances() != null) {
            sb.append("StoppingInstances: ").append(this.stoppingInstances()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StoppingInstances": {
                return Optional.of(clazz.cast(this.stoppingInstances()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private List<InstanceStateChange> stoppingInstances;

        private BuilderImpl() {
        }

        private BuilderImpl(StopInstancesResponse model) {
            this.stoppingInstances(model.stoppingInstances);
        }

        public final Collection<InstanceStateChange.Builder> getStoppingInstances() {
            return this.stoppingInstances != null ? (Collection)this.stoppingInstances.stream().map(InstanceStateChange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stoppingInstances(Collection<InstanceStateChange> stoppingInstances) {
            this.stoppingInstances = InstanceStateChangeListCopier.copy(stoppingInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stoppingInstances(InstanceStateChange ... stoppingInstances) {
            this.stoppingInstances(Arrays.asList(stoppingInstances));
            return this;
        }

        public final void setStoppingInstances(Collection<InstanceStateChange.BuilderImpl> stoppingInstances) {
            this.stoppingInstances = InstanceStateChangeListCopier.copyFromBuilder(stoppingInstances);
        }

        @Override
        public StopInstancesResponse build() {
            return new StopInstancesResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, StopInstancesResponse> {
        public Builder stoppingInstances(Collection<InstanceStateChange> var1);

        public Builder stoppingInstances(InstanceStateChange ... var1);
    }
}

