/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceAssociation;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class NetworkInterfacePrivateIpAddress
implements ToCopyableBuilder<Builder, NetworkInterfacePrivateIpAddress> {
    private final NetworkInterfaceAssociation association;
    private final Boolean primary;
    private final String privateDnsName;
    private final String privateIpAddress;

    private NetworkInterfacePrivateIpAddress(BuilderImpl builder) {
        this.association = builder.association;
        this.primary = builder.primary;
        this.privateDnsName = builder.privateDnsName;
        this.privateIpAddress = builder.privateIpAddress;
    }

    public NetworkInterfaceAssociation association() {
        return this.association;
    }

    public Boolean primary() {
        return this.primary;
    }

    public String privateDnsName() {
        return this.privateDnsName;
    }

    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.association());
        hashCode = 31 * hashCode + Objects.hashCode(this.primary());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIpAddress());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterfacePrivateIpAddress)) {
            return false;
        }
        NetworkInterfacePrivateIpAddress other = (NetworkInterfacePrivateIpAddress)obj;
        return Objects.equals(this.association(), other.association()) && Objects.equals(this.primary(), other.primary()) && Objects.equals(this.privateDnsName(), other.privateDnsName()) && Objects.equals(this.privateIpAddress(), other.privateIpAddress());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.association() != null) {
            sb.append("Association: ").append(this.association()).append(",");
        }
        if (this.primary() != null) {
            sb.append("Primary: ").append(this.primary()).append(",");
        }
        if (this.privateDnsName() != null) {
            sb.append("PrivateDnsName: ").append(this.privateDnsName()).append(",");
        }
        if (this.privateIpAddress() != null) {
            sb.append("PrivateIpAddress: ").append(this.privateIpAddress()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Association": {
                return Optional.of(clazz.cast(this.association()));
            }
            case "Primary": {
                return Optional.of(clazz.cast(this.primary()));
            }
            case "PrivateDnsName": {
                return Optional.of(clazz.cast(this.privateDnsName()));
            }
            case "PrivateIpAddress": {
                return Optional.of(clazz.cast(this.privateIpAddress()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private NetworkInterfaceAssociation association;
        private Boolean primary;
        private String privateDnsName;
        private String privateIpAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterfacePrivateIpAddress model) {
            this.association(model.association);
            this.primary(model.primary);
            this.privateDnsName(model.privateDnsName);
            this.privateIpAddress(model.privateIpAddress);
        }

        public final NetworkInterfaceAssociation.Builder getAssociation() {
            return this.association != null ? this.association.toBuilder() : null;
        }

        @Override
        public final Builder association(NetworkInterfaceAssociation association) {
            this.association = association;
            return this;
        }

        public final void setAssociation(NetworkInterfaceAssociation.BuilderImpl association) {
            this.association = association != null ? association.build() : null;
        }

        public final Boolean getPrimary() {
            return this.primary;
        }

        @Override
        public final Builder primary(Boolean primary) {
            this.primary = primary;
            return this;
        }

        public final void setPrimary(Boolean primary) {
            this.primary = primary;
        }

        public final String getPrivateDnsName() {
            return this.privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public NetworkInterfacePrivateIpAddress build() {
            return new NetworkInterfacePrivateIpAddress(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NetworkInterfacePrivateIpAddress> {
        public Builder association(NetworkInterfaceAssociation var1);

        default public Builder association(Consumer<NetworkInterfaceAssociation.Builder> association) {
            return this.association((NetworkInterfaceAssociation)((NetworkInterfaceAssociation.Builder)NetworkInterfaceAssociation.builder().apply(association)).build());
        }

        public Builder primary(Boolean var1);

        public Builder privateDnsName(String var1);

        public Builder privateIpAddress(String var1);
    }
}

