/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyVolumeAttributeRequest
extends EC2Request
implements ToCopyableBuilder<Builder, ModifyVolumeAttributeRequest> {
    private final Boolean autoEnableIO;
    private final String volumeId;

    private ModifyVolumeAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.autoEnableIO = builder.autoEnableIO;
        this.volumeId = builder.volumeId;
    }

    public Boolean autoEnableIO() {
        return this.autoEnableIO;
    }

    public String volumeId() {
        return this.volumeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoEnableIO());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVolumeAttributeRequest)) {
            return false;
        }
        ModifyVolumeAttributeRequest other = (ModifyVolumeAttributeRequest)((Object)obj);
        return Objects.equals(this.autoEnableIO(), other.autoEnableIO()) && Objects.equals(this.volumeId(), other.volumeId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.autoEnableIO() != null) {
            sb.append("AutoEnableIO: ").append(this.autoEnableIO()).append(",");
        }
        if (this.volumeId() != null) {
            sb.append("VolumeId: ").append(this.volumeId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoEnableIO": {
                return Optional.of(clazz.cast(this.autoEnableIO()));
            }
            case "VolumeId": {
                return Optional.of(clazz.cast(this.volumeId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private Boolean autoEnableIO;
        private String volumeId;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVolumeAttributeRequest model) {
            this.autoEnableIO(model.autoEnableIO);
            this.volumeId(model.volumeId);
        }

        public final Boolean getAutoEnableIO() {
            return this.autoEnableIO;
        }

        @Override
        public final Builder autoEnableIO(Boolean autoEnableIO) {
            this.autoEnableIO = autoEnableIO;
            return this;
        }

        public final void setAutoEnableIO(Boolean autoEnableIO) {
            this.autoEnableIO = autoEnableIO;
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ModifyVolumeAttributeRequest build() {
            return new ModifyVolumeAttributeRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, ModifyVolumeAttributeRequest> {
        public Builder autoEnableIO(Boolean var1);

        public Builder volumeId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

