/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.CreateVolumePermissionModifications;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.GroupNameStringListCopier;
import software.amazon.awssdk.services.ec2.model.OperationType;
import software.amazon.awssdk.services.ec2.model.SnapshotAttributeName;
import software.amazon.awssdk.services.ec2.model.UserIdStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifySnapshotAttributeRequest
extends EC2Request
implements ToCopyableBuilder<Builder, ModifySnapshotAttributeRequest> {
    private final String attribute;
    private final CreateVolumePermissionModifications createVolumePermission;
    private final List<String> groupNames;
    private final String operationType;
    private final String snapshotId;
    private final List<String> userIds;

    private ModifySnapshotAttributeRequest(BuilderImpl builder) {
        super(builder);
        this.attribute = builder.attribute;
        this.createVolumePermission = builder.createVolumePermission;
        this.groupNames = builder.groupNames;
        this.operationType = builder.operationType;
        this.snapshotId = builder.snapshotId;
        this.userIds = builder.userIds;
    }

    public SnapshotAttributeName attribute() {
        return SnapshotAttributeName.fromValue(this.attribute);
    }

    public String attributeString() {
        return this.attribute;
    }

    public CreateVolumePermissionModifications createVolumePermission() {
        return this.createVolumePermission;
    }

    public List<String> groupNames() {
        return this.groupNames;
    }

    public OperationType operationType() {
        return OperationType.fromValue(this.operationType);
    }

    public String operationTypeString() {
        return this.operationType;
    }

    public String snapshotId() {
        return this.snapshotId;
    }

    public List<String> userIds() {
        return this.userIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createVolumePermission());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifySnapshotAttributeRequest)) {
            return false;
        }
        ModifySnapshotAttributeRequest other = (ModifySnapshotAttributeRequest)((Object)obj);
        return Objects.equals(this.attributeString(), other.attributeString()) && Objects.equals(this.createVolumePermission(), other.createVolumePermission()) && Objects.equals(this.groupNames(), other.groupNames()) && Objects.equals(this.operationTypeString(), other.operationTypeString()) && Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.userIds(), other.userIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.attributeString() != null) {
            sb.append("Attribute: ").append(this.attributeString()).append(",");
        }
        if (this.createVolumePermission() != null) {
            sb.append("CreateVolumePermission: ").append(this.createVolumePermission()).append(",");
        }
        if (this.groupNames() != null) {
            sb.append("GroupNames: ").append(this.groupNames()).append(",");
        }
        if (this.operationTypeString() != null) {
            sb.append("OperationType: ").append(this.operationTypeString()).append(",");
        }
        if (this.snapshotId() != null) {
            sb.append("SnapshotId: ").append(this.snapshotId()).append(",");
        }
        if (this.userIds() != null) {
            sb.append("UserIds: ").append(this.userIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attribute": {
                return Optional.of(clazz.cast(this.attributeString()));
            }
            case "CreateVolumePermission": {
                return Optional.of(clazz.cast(this.createVolumePermission()));
            }
            case "GroupNames": {
                return Optional.of(clazz.cast(this.groupNames()));
            }
            case "OperationType": {
                return Optional.of(clazz.cast(this.operationTypeString()));
            }
            case "SnapshotId": {
                return Optional.of(clazz.cast(this.snapshotId()));
            }
            case "UserIds": {
                return Optional.of(clazz.cast(this.userIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private String attribute;
        private CreateVolumePermissionModifications createVolumePermission;
        private List<String> groupNames;
        private String operationType;
        private String snapshotId;
        private List<String> userIds;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifySnapshotAttributeRequest model) {
            this.attribute(model.attribute);
            this.createVolumePermission(model.createVolumePermission);
            this.groupNames(model.groupNames);
            this.operationType(model.operationType);
            this.snapshotId(model.snapshotId);
            this.userIds(model.userIds);
        }

        public final String getAttribute() {
            return this.attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(SnapshotAttributeName attribute) {
            this.attribute(attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final CreateVolumePermissionModifications.Builder getCreateVolumePermission() {
            return this.createVolumePermission != null ? this.createVolumePermission.toBuilder() : null;
        }

        @Override
        public final Builder createVolumePermission(CreateVolumePermissionModifications createVolumePermission) {
            this.createVolumePermission = createVolumePermission;
            return this;
        }

        public final void setCreateVolumePermission(CreateVolumePermissionModifications.BuilderImpl createVolumePermission) {
            this.createVolumePermission = createVolumePermission != null ? createVolumePermission.build() : null;
        }

        public final Collection<String> getGroupNames() {
            return this.groupNames;
        }

        @Override
        public final Builder groupNames(Collection<String> groupNames) {
            this.groupNames = GroupNameStringListCopier.copy(groupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupNames(String ... groupNames) {
            this.groupNames(Arrays.asList(groupNames));
            return this;
        }

        public final void setGroupNames(Collection<String> groupNames) {
            this.groupNames = GroupNameStringListCopier.copy(groupNames);
        }

        public final String getOperationType() {
            return this.operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        @Override
        public final Builder operationType(OperationType operationType) {
            this.operationType(operationType.toString());
            return this;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final Collection<String> getUserIds() {
            return this.userIds;
        }

        @Override
        public final Builder userIds(Collection<String> userIds) {
            this.userIds = UserIdStringListCopier.copy(userIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userIds(String ... userIds) {
            this.userIds(Arrays.asList(userIds));
            return this;
        }

        public final void setUserIds(Collection<String> userIds) {
            this.userIds = UserIdStringListCopier.copy(userIds);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ModifySnapshotAttributeRequest build() {
            return new ModifySnapshotAttributeRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, ModifySnapshotAttributeRequest> {
        public Builder attribute(String var1);

        public Builder attribute(SnapshotAttributeName var1);

        public Builder createVolumePermission(CreateVolumePermissionModifications var1);

        default public Builder createVolumePermission(Consumer<CreateVolumePermissionModifications.Builder> createVolumePermission) {
            return this.createVolumePermission((CreateVolumePermissionModifications)((CreateVolumePermissionModifications.Builder)CreateVolumePermissionModifications.builder().apply(createVolumePermission)).build());
        }

        public Builder groupNames(Collection<String> var1);

        public Builder groupNames(String ... var1);

        public Builder operationType(String var1);

        public Builder operationType(OperationType var1);

        public Builder snapshotId(String var1);

        public Builder userIds(Collection<String> var1);

        public Builder userIds(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

